/*
 * Decompiled with CFR 0.152.
 */
package be.fluid_it.\u00b5s.bundle.guice;

import com.google.inject.Module;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class Modules {
    private static final String DISABLED = "disabled";

    public static List<Module> find(Class<? extends Module> moduleClass) {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (Module module : ServiceLoader.load(moduleClass)) {
            if (Modules.isDisabled(module.getClass())) continue;
            modules.add(module);
        }
        return modules;
    }

    public static boolean isDisabled(Class<? extends Module> moduleClass) {
        String moduleValue;
        String moduleKey = moduleClass.getName();
        if (System.getProperties().containsKey(moduleKey) && (moduleValue = System.getProperty(moduleKey)) != null) {
            return DISABLED.equals(moduleValue);
        }
        return false;
    }

    public static void disable(Class<? extends Module> moduleClass) {
        if (moduleClass != null) {
            System.setProperty(moduleClass.getName(), DISABLED);
        }
    }

    public static void resetDisabled() {
        LinkedList<String> keysToClear = new LinkedList<String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object value = entry.getValue();
            if (value == null || !DISABLED.equals(value)) continue;
            keysToClear.add(entry.getKey().toString());
        }
        for (String keyToClear : keysToClear) {
            System.clearProperty(keyToClear);
        }
    }
}

