/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.SubscriptionRequest;
import be.feelio.mollie.json.request.UpdateSubscriptionRequest;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.SubscriptionListResponse;
import be.feelio.mollie.json.response.SubscriptionResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionHandler.class);

    public SubscriptionHandler(String baseUrl) {
        super(baseUrl);
    }

    public SubscriptionResponse createSubscription(String customerId, SubscriptionRequest body) throws MollieException {
        return this.createSubscription(customerId, body, QueryParams.EMPTY);
    }

    public SubscriptionResponse createSubscription(String customerId, SubscriptionRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/subscriptions" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = Unirest.post((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId) throws MollieException {
        return this.getSubscription(customerId, subscriptionId, QueryParams.EMPTY);
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId) throws MollieException {
        return this.cancelSubscription(customerId, subscriptionId, QueryParams.EMPTY);
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + params.toString();
            log.info("Executing 'DELETE {}'", (Object)url);
            HttpResponse response = Unirest.delete((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'DELETE {}'", (Object)url);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<SubscriptionListResponse> listSubscriptions(String customerId) throws MollieException {
        return this.listSubscriptions(customerId, QueryParams.EMPTY);
    }

    public Pagination<SubscriptionListResponse> listSubscriptions(String customerId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/subscriptions" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<SubscriptionListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listSubscriptionPayments(String customerId, String subscriptionId) throws MollieException {
        return this.listSubscriptionPayments(customerId, subscriptionId, QueryParams.EMPTY);
    }

    public Pagination<PaymentListResponse> listSubscriptionPayments(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + "/payments" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest body) throws MollieException {
        return this.updateSubscription(customerId, subscriptionId, body, QueryParams.EMPTY);
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + params.toString();
            log.info("Executing 'PATCH {}'", (Object)url);
            HttpResponse response = Unirest.patch((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'PATCH {}'", (Object)url);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

