/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.RefundRequest;
import be.feelio.mollie.json.response.RefundListResponse;
import be.feelio.mollie.json.response.RefundResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefundHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(RefundHandler.class);

    public RefundHandler(String baseUrl) {
        super(baseUrl);
    }

    public RefundResponse createRefund(String paymentId, RefundRequest body) throws MollieException {
        return this.createRefund(paymentId, body, QueryParams.EMPTY);
    }

    public RefundResponse createRefund(String paymentId, RefundRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + "/refunds" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = Unirest.post((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public RefundResponse getRefund(String paymentId, String refundId) throws MollieException {
        return this.getRefund(paymentId, refundId, QueryParams.EMPTY);
    }

    public RefundResponse getRefund(String paymentId, String refundId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + "/refunds/" + refundId + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void cancelRefund(String paymentId, String refundId) throws MollieException {
        this.cancelRefund(paymentId, refundId, QueryParams.EMPTY);
    }

    public void cancelRefund(String paymentId, String refundId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + "/refunds/" + refundId + params.toString();
            log.info("Executing 'DELETE {}'", (Object)url);
            HttpResponse response = Unirest.delete((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'DELETE {}'", (Object)url);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> listRefunds() throws MollieException {
        return this.listRefunds(QueryParams.EMPTY);
    }

    public Pagination<RefundListResponse> listRefunds(QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/refunds" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> listRefunds(String paymentId) throws MollieException {
        return this.listRefunds(paymentId, QueryParams.EMPTY);
    }

    public Pagination<RefundListResponse> listRefunds(String paymentId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + "/refunds" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

