/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.PaymentRequest;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.PaymentResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(PaymentHandler.class);

    public PaymentHandler(String baseUrl) {
        super(baseUrl);
    }

    public PaymentResponse createPayment(PaymentRequest body) throws MollieException {
        return this.createPayment(body, QueryParams.EMPTY);
    }

    public PaymentResponse createPayment(PaymentRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = Unirest.post((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse getPayment(String paymentId) throws MollieException {
        return this.getPayment(paymentId, QueryParams.EMPTY);
    }

    public PaymentResponse getPayment(String paymentId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse cancelPayment(String paymentId) throws MollieException {
        return this.cancelPayment(paymentId, QueryParams.EMPTY);
    }

    public PaymentResponse cancelPayment(String paymentId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + params.toString();
            log.info("Executing 'DELETE {}'", (Object)url);
            HttpResponse response = Unirest.delete((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'DELETE {}'", (Object)url);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listPayments() throws MollieException {
        return this.listPayments(QueryParams.EMPTY);
    }

    public Pagination<PaymentListResponse> listPayments(QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/payments" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

