/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.MandateRequest;
import be.feelio.mollie.json.response.MandateListResponse;
import be.feelio.mollie.json.response.MandateResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MandateHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(MandateHandler.class);

    public MandateHandler(String baseUrl) {
        super(baseUrl);
    }

    public MandateResponse createMandate(String customerId, MandateRequest body) throws MollieException {
        return this.createMandate(customerId, body, QueryParams.EMPTY);
    }

    public MandateResponse createMandate(String customerId, MandateRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/mandates" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = Unirest.post((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (MandateResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MandateResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public MandateResponse getMandate(String customerId, String mandateId) throws MollieException {
        return this.getMandate(customerId, mandateId, QueryParams.EMPTY);
    }

    public MandateResponse getMandate(String customerId, String mandateId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/mandates/" + mandateId + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (MandateResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MandateResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void revokeMandate(String customerId, String mandateId) throws MollieException {
        this.revokeMandate(customerId, mandateId, QueryParams.EMPTY);
    }

    public void revokeMandate(String customerId, String mandateId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/mandates/" + mandateId + params.toString();
            log.info("Executing 'DELETE {}'", (Object)url);
            HttpResponse response = Unirest.delete((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'DELETE {}'", (Object)url);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<MandateListResponse> listMandates(String customerId) throws MollieException {
        return this.listMandates(customerId, QueryParams.EMPTY);
    }

    public Pagination<MandateListResponse> listMandates(String customerId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/mandates" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<MandateListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

