/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.CustomerRequest;
import be.feelio.mollie.json.request.PaymentRequest;
import be.feelio.mollie.json.response.CustomerListResponse;
import be.feelio.mollie.json.response.CustomerResponse;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.PaymentResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomerHandler.class);

    public CustomerHandler(String baseUrl) {
        super(baseUrl);
    }

    public CustomerResponse createCustomer(CustomerRequest body) throws MollieException {
        return this.createCustomer(body, QueryParams.EMPTY);
    }

    public CustomerResponse createCustomer(CustomerRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = Unirest.post((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public CustomerResponse getCustomer(String customerId) throws MollieException {
        return this.getCustomer(customerId, QueryParams.EMPTY);
    }

    public CustomerResponse getCustomer(String customerId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public CustomerResponse updateCustomer(String customerId, CustomerRequest body) throws MollieException {
        return this.updateCustomer(customerId, body, QueryParams.EMPTY);
    }

    public CustomerResponse updateCustomer(String customerId, CustomerRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + params.toString();
            log.info("Executing 'PATCH {}'", (Object)url);
            HttpResponse response = Unirest.patch((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'PATCH {}'", (Object)url);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public void deleteCustomer(String customerId) throws MollieException {
        this.deleteCustomer(customerId, QueryParams.EMPTY);
    }

    public void deleteCustomer(String customerId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + params.toString();
            log.info("Executing 'DELETE {}'", (Object)url);
            HttpResponse response = Unirest.delete((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'DELETE {}'", (Object)url);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<CustomerListResponse> listCustomers() throws MollieException {
        return this.listCustomers(QueryParams.EMPTY);
    }

    public Pagination<CustomerListResponse> listCustomers(QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<CustomerListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public PaymentResponse createCustomerPayment(String customerId, PaymentRequest body) throws MollieException {
        return this.createCustomerPayment(customerId, body, QueryParams.EMPTY);
    }

    public PaymentResponse createCustomerPayment(String customerId, PaymentRequest body, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/payments" + params.toString();
            log.info("Executing 'POST {}'", (Object)url);
            HttpResponse response = Unirest.post((String)url).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'POST {}'", (Object)url);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listCustomerPayments(String customerId) throws MollieException {
        return this.listCustomerPayments(customerId, QueryParams.EMPTY);
    }

    public Pagination<PaymentListResponse> listCustomerPayments(String customerId, QueryParams params) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/payments" + params.toString();
            log.info("Executing 'GET {}'", (Object)url);
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            log.info("Successful response 'GET {}'", (Object)url);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            log.error("An unexpected exception occurred", ex);
            throw new MollieException(ex);
        }
    }
}

