/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.SubscriptionRequest;
import be.feelio.mollie.json.request.UpdateSubscriptionRequest;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.SubscriptionListResponse;
import be.feelio.mollie.json.response.SubscriptionResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class SubscriptionHandler
extends AbstractHandler {
    public SubscriptionHandler(String baseUrl) {
        super(baseUrl);
    }

    public SubscriptionResponse createSubscription(String customerId, SubscriptionRequest body) throws MollieException {
        return this.createSubscription(customerId, body, QueryParams.EMPTY);
    }

    public SubscriptionResponse createSubscription(String customerId, SubscriptionRequest body, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/customers/" + customerId + "/subscriptions" + params.toString())).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId) throws MollieException {
        return this.getSubscription(customerId, subscriptionId, QueryParams.EMPTY);
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId) throws MollieException {
        return this.cancelSubscription(customerId, subscriptionId, QueryParams.EMPTY);
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.delete((String)(this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<SubscriptionListResponse> listSubscriptions(String customerId) throws MollieException {
        return this.listSubscriptions(customerId, QueryParams.EMPTY);
    }

    public Pagination<SubscriptionListResponse> listSubscriptions(String customerId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers/" + customerId + "/subscriptions" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<SubscriptionListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listSubscriptionPayments(String customerId, String subscriptionId) throws MollieException {
        return this.listSubscriptionPayments(customerId, subscriptionId, QueryParams.EMPTY);
    }

    public Pagination<PaymentListResponse> listSubscriptionPayments(String customerId, String subscriptionId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + "/payments" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest body) throws MollieException {
        return this.updateSubscription(customerId, subscriptionId, body, QueryParams.EMPTY);
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest body, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.patch((String)(this.baseUrl + "/customers/" + customerId + "/subscriptions/" + subscriptionId + params.toString())).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (SubscriptionResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), SubscriptionResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

