/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.MandateRequest;
import be.feelio.mollie.json.response.MandateListResponse;
import be.feelio.mollie.json.response.MandateResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class MandateHandler
extends AbstractHandler {
    public MandateHandler(String baseUrl) {
        super(baseUrl);
    }

    public MandateResponse createMandate(String customerId, MandateRequest body) throws MollieException {
        return this.createMandate(customerId, body, QueryParams.EMPTY);
    }

    public MandateResponse createMandate(String customerId, MandateRequest body, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/customers/" + customerId + "/mandates" + params.toString())).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (MandateResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MandateResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public MandateResponse getMandate(String customerId, String mandateId) throws MollieException {
        return this.getMandate(customerId, mandateId, QueryParams.EMPTY);
    }

    public MandateResponse getMandate(String customerId, String mandateId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers/" + customerId + "/mandates/" + mandateId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (MandateResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), MandateResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public void revokeMandate(String customerId, String mandateId) throws MollieException {
        this.revokeMandate(customerId, mandateId, QueryParams.EMPTY);
    }

    public void revokeMandate(String customerId, String mandateId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.delete((String)(this.baseUrl + "/customers/" + customerId + "/mandates/" + mandateId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<MandateListResponse> listMandates(String customerId) throws MollieException {
        return this.listMandates(customerId, QueryParams.EMPTY);
    }

    public Pagination<MandateListResponse> listMandates(String customerId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers/" + customerId + "/mandates" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<MandateListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

