/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.CustomerRequest;
import be.feelio.mollie.json.request.PaymentRequest;
import be.feelio.mollie.json.response.CustomerListResponse;
import be.feelio.mollie.json.response.CustomerResponse;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.PaymentResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class CustomerHandler
extends AbstractHandler {
    public CustomerHandler(String baseUrl) {
        super(baseUrl);
    }

    public CustomerResponse createCustomer(CustomerRequest body) throws MollieException {
        return this.createCustomer(body, QueryParams.EMPTY);
    }

    public CustomerResponse createCustomer(CustomerRequest body, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/customers" + params.toString())).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public CustomerResponse getCustomer(String customerId) throws MollieException {
        return this.getCustomer(customerId, QueryParams.EMPTY);
    }

    public CustomerResponse getCustomer(String customerId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers/" + customerId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public CustomerResponse updateCustomer(String customerId, CustomerRequest body) throws MollieException {
        return this.updateCustomer(customerId, body, QueryParams.EMPTY);
    }

    public CustomerResponse updateCustomer(String customerId, CustomerRequest body, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.patch((String)(this.baseUrl + "/customers/" + customerId + params.toString())).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (CustomerResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), CustomerResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public void deleteCustomer(String customerId) throws MollieException {
        this.deleteCustomer(customerId, QueryParams.EMPTY);
    }

    public void deleteCustomer(String customerId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.delete((String)(this.baseUrl + "/customers/" + customerId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<CustomerListResponse> getCustomers() throws MollieException {
        return this.getCustomers(QueryParams.EMPTY);
    }

    public Pagination<CustomerListResponse> getCustomers(QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/customers" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<CustomerListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public PaymentResponse createCustomerPayment(String customerId, PaymentRequest body) throws MollieException {
        return this.createCustomerPayment(customerId, body, QueryParams.EMPTY);
    }

    public PaymentResponse createCustomerPayment(String customerId, PaymentRequest body, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/customers/" + customerId + "/payments" + params.toString())).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listCustomerPayments(String customerId) throws MollieException {
        return this.listCustomerPayments(customerId, QueryParams.EMPTY);
    }

    public Pagination<PaymentListResponse> listCustomerPayments(String customerId, QueryParams queryParams) throws MollieException {
        try {
            String url = this.baseUrl + "/customers/" + customerId + "/payments" + queryParams.toString();
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

