/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.RefundRequest;
import be.feelio.mollie.json.response.RefundListResponse;
import be.feelio.mollie.json.response.RefundResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class RefundHandler
extends AbstractHandler {
    public RefundHandler(String baseUrl) {
        super(baseUrl);
    }

    public RefundResponse createRefund(String paymentId, RefundRequest body) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/payments/" + paymentId + "/refunds")).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public RefundResponse getRefund(String paymentId, String refundId) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/payments/" + paymentId + "/refunds/" + refundId)).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (RefundResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), RefundResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public void cancelRefund(String paymentId, String refundId) throws MollieException {
        try {
            HttpResponse response = Unirest.delete((String)(this.baseUrl + "/payments/" + paymentId + "/refunds/" + refundId)).asString();
            this.validateResponse((HttpResponse<String>)response);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> getRefunds() throws MollieException {
        return this.getRefunds(QueryParams.EMPTY);
    }

    public Pagination<RefundListResponse> getRefunds(QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/refunds" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<RefundListResponse> getRefunds(String paymentId) throws MollieException {
        return this.getRefunds(paymentId, QueryParams.EMPTY);
    }

    public Pagination<RefundListResponse> getRefunds(String paymentId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/payments/" + paymentId + "/refunds" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<RefundListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

