/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.response.CaptureListResponse;
import be.feelio.mollie.json.response.CaptureResponse;
import be.feelio.mollie.json.response.ChargebackListResponse;
import be.feelio.mollie.json.response.ChargebackResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class CaptureHandler
extends AbstractHandler {
    public CaptureHandler(String baseUrl) {
        super(baseUrl);
    }

    public CaptureResponse getCapture(String paymentId, String captureId) throws MollieException {
        return this.getCapture(paymentId, captureId, QueryParams.EMPTY);
    }

    public CaptureResponse getCapture(String paymentId, String captureId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/payments/" + paymentId + "/captures/" + captureId + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (CaptureResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<ChargebackResponse>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<CaptureListResponse> getCaptures(String paymentId) throws MollieException {
        return this.getCaptures(paymentId, QueryParams.EMPTY);
    }

    public Pagination<CaptureListResponse> getCaptures(String paymentId, QueryParams params) throws MollieException {
        try {
            HttpResponse response = Unirest.get((String)(this.baseUrl + "/payments/" + paymentId + "/captures" + params.toString())).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<ChargebackListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

