/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.PaymentRequest;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.PaymentResponse;
import be.feelio.mollie.util.ObjectMapperService;
import be.feelio.mollie.util.QueryParams;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class PaymentHandler
extends AbstractHandler {
    public PaymentHandler(String baseUrl) {
        super(baseUrl);
    }

    public PaymentResponse createPayment(PaymentRequest body) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/payments")).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public PaymentResponse getPayment(String paymentId) throws MollieException {
        return this.getPayment(paymentId, QueryParams.EMPTY);
    }

    public PaymentResponse getPayment(String paymentId, QueryParams queryParams) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId + queryParams.toString();
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public PaymentResponse cancelPayment(String paymentId) throws MollieException {
        try {
            HttpResponse response = Unirest.delete((String)(this.baseUrl + "/payments/" + paymentId)).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listPayments() throws MollieException {
        return this.listPayments(QueryParams.EMPTY);
    }

    public Pagination<PaymentListResponse> listPayments(QueryParams queryParams) throws MollieException {
        try {
            String url = this.baseUrl + "/payments" + queryParams.toString();
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

