/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie;

import be.feelio.mollie.handler.MethodHandler;
import be.feelio.mollie.handler.PaymentHandler;
import be.feelio.mollie.util.ObjectMapperService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import java.io.IOException;

public class Client {
    private final String endpoint;
    private final String apiKey;

    public Client(String version, String apiKey) {
        this.endpoint = "https://api.mollie.com/" + version;
        this.apiKey = apiKey;
        this.initUniRest();
    }

    public PaymentHandler payments() {
        return new PaymentHandler(this.endpoint);
    }

    public MethodHandler methods() {
        return new MethodHandler(this.endpoint);
    }

    private void initUniRest() {
        Unirest.setDefaultHeader((String)"Authorization", (String)("Bearer " + this.apiKey));
        Unirest.setDefaultHeader((String)"Content-Type", (String)"application/json");
        Unirest.setObjectMapper((ObjectMapper)new ObjectMapper(){

            public <T> T readValue(String value, Class<T> type) {
                try {
                    return (T)ObjectMapperService.getInstance().getMapper().readValue(value, type);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return ObjectMapperService.getInstance().getMapper().writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

