/*
 * Decompiled with CFR 0.152.
 */
package be.feelio.mollie.handler;

import be.feelio.mollie.exception.MollieException;
import be.feelio.mollie.handler.AbstractHandler;
import be.feelio.mollie.json.common.Pagination;
import be.feelio.mollie.json.request.PaymentRequest;
import be.feelio.mollie.json.response.PaymentListResponse;
import be.feelio.mollie.json.response.PaymentResponse;
import be.feelio.mollie.util.ObjectMapperService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;

public class PaymentHandler
extends AbstractHandler {
    public PaymentHandler(String baseUrl) {
        super(baseUrl);
    }

    public PaymentResponse createPayment(PaymentRequest body) throws MollieException {
        try {
            HttpResponse response = Unirest.post((String)(this.baseUrl + "/payments")).body((Object)body).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public PaymentResponse getPayment(String paymentId) throws MollieException {
        return this.getPayment(paymentId, false, false);
    }

    public PaymentResponse getPayment(String paymentId, boolean withRefunds, boolean withChargebacks) throws MollieException {
        try {
            String url = this.baseUrl + "/payments/" + paymentId;
            if (withRefunds && withChargebacks) {
                url = url + "?embed=refunds,chargebacks";
            } else if (withRefunds) {
                url = url + "?embed=refunds";
            } else if (withChargebacks) {
                url = url + "?embed=chargebacks";
            }
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public PaymentResponse cancelPayment(String paymentId) throws MollieException {
        try {
            HttpResponse response = Unirest.delete((String)(this.baseUrl + "/payments/" + paymentId)).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (PaymentResponse)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), PaymentResponse.class);
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }

    public Pagination<PaymentListResponse> listPayments() throws MollieException {
        return this.listPayments(null, -1);
    }

    public Pagination<PaymentListResponse> listPayments(String from) throws MollieException {
        return this.listPayments(from, -1);
    }

    public Pagination<PaymentListResponse> listPayments(int limit) throws MollieException {
        return this.listPayments(null, limit);
    }

    public Pagination<PaymentListResponse> listPayments(String from, int limit) throws MollieException {
        try {
            String url = this.baseUrl + "/payments";
            if (from != null && !from.isEmpty() && limit > 0) {
                url = url + "?limit=" + limit + "&from=" + from;
            } else if (from != null && !from.isEmpty()) {
                url = url + "?from=" + from;
            } else if (limit > 0) {
                url = url + "?limit=" + limit;
            }
            HttpResponse response = Unirest.get((String)url).asString();
            this.validateResponse((HttpResponse<String>)response);
            return (Pagination)ObjectMapperService.getInstance().getMapper().readValue((String)response.getBody(), (TypeReference)new TypeReference<Pagination<PaymentListResponse>>(){});
        }
        catch (UnirestException | IOException ex) {
            throw new MollieException(ex);
        }
    }
}

