/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.jfaker.mockito;

import be.eliwan.jfaker.mockito.FakerMock;
import be.eliwan.jfaker.mockito.Person;
import org.fest.assertions.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FakerMockTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testWithFields() throws Exception {
        Person person = (Person)FakerMock.withFields(Person.class, (Object[])new Object[]{"name", "John Doe", "single", true, "address", "Church Street 12", "numberOfChildren", 2});
        Assertions.assertThat((String)person.getName()).isEqualTo((Object)"John Doe");
        Assertions.assertThat((boolean)person.isSingle()).isTrue();
        Assertions.assertThat((String)person.getAddress()).isEqualTo((Object)"Church Street 12");
        Assertions.assertThat((int)person.getNumberOfChildren()).isEqualTo(2);
        Assertions.assertThat((String)person.getLocation()).isNull();
    }

    @Test
    public void testWithField_nameWithoutValue() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Odd number of parameters, incomplete set of field names and values.");
        FakerMock.withFields(Person.class, (Object[])new Object[]{"name"});
    }

    @Test
    public void testWithField_nameIsNotString() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Key 1 is not string.");
        FakerMock.withFields(Person.class, (Object[])new Object[]{1, 2});
    }
}

