/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.jdbc;

import be.eliwan.profiling.jdbc.ProfilingDriver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProfilingInvocationHandler
implements InvocationHandler {
    private String groupPrefix;
    private Object delegate;
    private String query;

    public ProfilingInvocationHandler(String groupPrefix, Object delegate) {
        this.groupPrefix = groupPrefix;
        this.delegate = delegate;
    }

    public ProfilingInvocationHandler(String groupPrefix, Object delegate, String query) {
        this.groupPrefix = groupPrefix;
        this.delegate = delegate;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isGetterOrSetter(method)) {
            return method.invoke(this.delegate, args);
        }
        long start = System.currentTimeMillis();
        String query = this.extractQuery(method, args);
        try {
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        finally {
            ProfilingDriver.register(this.groupPrefix + method.getName(), System.currentTimeMillis() - start);
            if (null != query) {
                ProfilingDriver.registerQuery(this.groupPrefix + method.getName(), query, System.currentTimeMillis() - start);
            }
        }
    }

    private String extractQuery(Method method, Object[] args) {
        String res = null;
        String methodName = method.getName();
        if (("execute".equals(methodName) || "executeQuery".equals(methodName) || "executeUpdate".equals(methodName)) && null != args && 1 == args.length && args[0] instanceof String) {
            res = (String)args[0];
        }
        if (("execute".equals(methodName) || "executeQuery".equals(methodName) || "executeUpdate".equals(methodName)) && (null == args || 0 == args.length)) {
            res = this.query;
        }
        return res;
    }

    private boolean isGetterOrSetter(Method method) {
        try {
            String methodName = method.getName();
            return methodName.startsWith("get") && !"getResultSet".equals(methodName) && !"getMoreResults".equals(methodName) || methodName.startsWith("is") || methodName.startsWith("set");
        }
        catch (Exception ex) {
            return false;
        }
    }
}

