/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.service;

import be.eliwan.profiling.api.GroupData;
import be.eliwan.profiling.api.ProfilingData;
import be.eliwan.profiling.service.ProfilingContainer;
import java.util.List;
import org.junit.Test;

public class ProfilingContainerTest {
    private static final int ITERATIONS = 10000000;
    private static final int PREFIX_DIVISOR = 3700000;
    private static final int THREADS = 4;
    private static final String[] GROUP = new String[]{"zero", "g1", "g2", "group 3", "four"};
    private static final String[] PREFIX = new String[]{"", "more.", "another-", "xxx-", "[({?"};

    @Test
    public void profilingContainerTest() throws Exception {
        ProfilingContainer container = new ProfilingContainer();
        container.setRingSize(128);
        container.start();
        Thread[] threads = new Thread[4];
        for (int i = 0; i < 4; ++i) {
            threads[i] = new Filler(container);
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < 4; ++i) {
            threads[i].start();
        }
        boolean done = false;
        int waitThread = 0;
        while (!done) {
            this.output(container);
            threads[waitThread].join(1000L);
            if (!threads[waitThread].isAlive()) {
                ++waitThread;
            }
            done = true;
            for (int i = 0; i < 4; ++i) {
                done &= !threads[i].isAlive();
            }
        }
        System.out.print("DONE");
        this.output(container);
        System.out.println("Total run time (in ms): " + (System.currentTimeMillis() - start));
    }

    private void output(ProfilingContainer container) {
        System.out.println("-----------------");
        ProfilingData total = container.getTotal();
        List gd = container.getGroupData();
        System.out.println("TOTAL: " + total.getInvocationCount() + "  " + total.getTotalRunTime() + "  avg " + total.getAverageRunTime());
        for (GroupData g : gd) {
            System.out.printf("%20s:  %8d %8d %.3f\n", g.getGroup(), g.getInvocationCount(), g.getTotalRunTime(), g.getAverageRunTime());
        }
    }

    private static class Filler
    extends Thread {
        ProfilingContainer container;

        public Filler(ProfilingContainer container) {
            this.container = container;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10000000; ++i) {
                long duration = i % 5 + 1;
                String group = PREFIX[i / 3700000] + GROUP[i % GROUP.length];
                this.container.register(group, duration);
            }
        }
    }
}

