/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.jdbc;

import be.eliwan.profiling.api.GroupData;
import be.eliwan.profiling.jdbc.ProfilingDriver;
import be.eliwan.profiling.jdbc.ProfilingListener;
import be.eliwan.profiling.service.ProfilingContainer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ProfilingDriverTest {
    private Connection connection;
    private ProfilingContainer profilingContainer;

    @Before
    public void getConnection() throws Exception {
        Class.forName("be.eliwan.profiling.jdbc.ProfilingDriver");
        Class.forName("org.hsqldb.jdbcDriver");
        this.profilingContainer = new ProfilingContainer();
        this.profilingContainer.start();
        ProfilingDriver.addListener((ProfilingListener)new ProfilingListener(){

            public void register(String group, long durationMillis) {
                ProfilingDriverTest.this.profilingContainer.register(group, durationMillis);
            }

            public void registerQuery(String group, String query, long durationMillis) {
                ProfilingDriverTest.this.profilingContainer.register(group + ":" + query, durationMillis);
            }
        });
        this.connection = DriverManager.getConnection("profiling:jdbc:hsqldb:mem:testdb", "sa", "");
    }

    @After
    public void closeConnection() throws Exception {
        this.sql("SHUTDOWN");
        this.connection.close();
    }

    private ResultSet sql(String sql) throws Exception {
        Statement st = this.connection.createStatement();
        st.execute(sql);
        return st.getResultSet();
    }

    @Test
    public void testProfilingDriver() throws Exception {
        Thread.sleep(100L);
        List groupsData = this.profilingContainer.getGroupData();
        Assertions.assertThat((List)groupsData).hasSize(1);
        Assertions.assertThat((String)((GroupData)groupsData.get(0)).getGroup()).isEqualTo((Object)"Driver.connect");
        Assertions.assertThat((long)((GroupData)groupsData.get(0)).getInvocationCount()).isEqualTo(1L);
        this.profilingContainer.clear();
        this.sql("CREATE TABLE bla (\nVERSION INTEGER,\nNAME VARCHAR(255)\n);");
        this.sql("INSERT INTO bla (NAME, VERSION) values ('zzz', 8)");
        ResultSet resultSet = this.sql("SELECT * from bla");
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
        Assertions.assertThat((String)resultSet.getString("NAME")).isEqualTo((Object)"zzz");
        Assertions.assertThat((int)resultSet.getInt("VERSION")).isEqualTo(8);
        Thread.sleep(100L);
        groupsData = this.profilingContainer.getGroupData();
        Assertions.assertThat((List)groupsData).hasSize(6);
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"[GroupContainer{group='Connection.createStatement', OneContainer{invocationCount=3"});
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"GroupContainer{group='Statement.execute', OneContainer{invocationCount=3"});
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"GroupContainer{group='Statement.getResultSet', OneContainer{invocationCount=3"});
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"GroupContainer{group='Statement.execute:SELECT * from bla', OneContainer{invocationCount=1"});
        this.profilingContainer.clear();
        PreparedStatement ps = this.connection.prepareStatement("SELECT NAME, VERSION as V from bla");
        ps.execute();
        ps.execute();
        resultSet = ps.getResultSet();
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
        Assertions.assertThat((String)resultSet.getString("NAME")).isEqualTo((Object)"zzz");
        Assertions.assertThat((int)resultSet.getInt("V")).isEqualTo(8);
        Thread.sleep(100L);
        groupsData = this.profilingContainer.getGroupData();
        Assertions.assertThat((List)groupsData).hasSize(4);
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"[GroupContainer{group='Connection.prepareStatement', OneContainer{invocationCount=1"});
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"GroupContainer{group='PreparedStatement.execute', OneContainer{invocationCount=2"});
        Assertions.assertThat((String)groupsData.toString()).contains(new CharSequence[]{"GroupContainer{group='PreparedStatement.getResultSet', OneContainer{invocationCount=1"});
        this.profilingContainer.clear();
    }
}

