/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.jdbc;

import be.eliwan.profiling.jdbc.ConnectionInvocationHandler;
import be.eliwan.profiling.jdbc.ProfilingListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class ProfilingDriver
implements Driver {
    private static final String PREFIX = "profiling:";
    private static final String PREFIX_ALT = "jdbc:profiling:";
    private static final List<ProfilingListener> LISTENERS = new CopyOnWriteArrayList<ProfilingListener>();

    public static void addListener(ProfilingListener listener) {
        LISTENERS.add(listener);
    }

    static void register(String group, long durationMillis) {
        for (ProfilingListener listener : LISTENERS) {
            listener.register(group, durationMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String s, Properties properties) throws SQLException {
        if (this.acceptsURL(s)) {
            long start = System.currentTimeMillis();
            try {
                String realUrl = "";
                realUrl = s.startsWith(PREFIX_ALT) ? s.substring(PREFIX_ALT.length()) : s.substring(PREFIX.length());
                Connection connection = DriverManager.getConnection(realUrl, properties);
                if (null != connection) {
                    Connection connection2 = (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(connection));
                    return connection2;
                }
            }
            finally {
                ProfilingDriver.register("Driver.connect", System.currentTimeMillis() - start);
            }
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String s) throws SQLException {
        return s.startsWith(PREFIX) || s.startsWith(PREFIX_ALT);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new ProfilingDriver());
        }
        catch (SQLException se) {
            throw new IllegalStateException("Cannot register ProfilingDriver SQL driver.", se);
        }
    }
}

