/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.jdbc;

import be.eliwan.profiling.jdbc.ProfilingDriver;
import be.eliwan.profiling.jdbc.ProfilingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class ConnectionInvocationHandler
implements InvocationHandler {
    private Connection delegate;

    public ConnectionInvocationHandler(Connection delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isGetterOrSetter(method)) {
            return method.invoke((Object)this.delegate, args);
        }
        long start = System.currentTimeMillis();
        try {
            if ("prepareCall".equals(method.getName())) {
                CallableStatement callableStatement = (CallableStatement)method.invoke((Object)this.delegate, args);
                Object object = Proxy.newProxyInstance(callableStatement.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new ProfilingInvocationHandler("CallableStatement.", callableStatement));
                return object;
            }
            if ("prepareStatement".equals(method.getName())) {
                PreparedStatement preparedStatement = (PreparedStatement)method.invoke((Object)this.delegate, args);
                Object object = Proxy.newProxyInstance(preparedStatement.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new ProfilingInvocationHandler("PreparedStatement.", preparedStatement));
                return object;
            }
            if ("createStatement".equals(method.getName())) {
                Statement statement = (Statement)method.invoke((Object)this.delegate, args);
                Object object = Proxy.newProxyInstance(statement.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new ProfilingInvocationHandler("Statement.", statement));
                return object;
            }
            Object object = method.invoke((Object)this.delegate, args);
            return object;
        }
        finally {
            ProfilingDriver.register("Connection." + method.getName(), System.currentTimeMillis() - start);
        }
    }

    private boolean isGetterOrSetter(Method method) {
        try {
            String methodName = method.getName();
            return methodName.startsWith("get") || methodName.startsWith("is") || methodName.startsWith("set") || "clearWarnings".equals(methodName);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

