/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.jdbc;

import be.eliwan.profiling.jdbc.ProfilingDriver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProfilingInvocationHandler
implements InvocationHandler {
    private String groupPrefix;
    private Object delegate;

    public ProfilingInvocationHandler(String groupPrefix, Object delegate) {
        this.groupPrefix = groupPrefix;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isGetterOrSetter(method)) {
            return method.invoke(this.delegate, args);
        }
        long start = System.currentTimeMillis();
        try {
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        finally {
            ProfilingDriver.register(this.groupPrefix + method.getName(), System.currentTimeMillis() - start);
        }
    }

    private boolean isGetterOrSetter(Method method) {
        try {
            String methodName = method.getName();
            return methodName.startsWith("get") && !"getResultSet".equals(methodName) && !"getMoreResults".equals(methodName) || methodName.startsWith("is") || methodName.startsWith("set");
        }
        catch (Exception ex) {
            return false;
        }
    }
}

