/*
 * Decompiled with CFR 0.152.
 */
package be.eliwan.profiling.service;

import be.eliwan.profiling.api.GroupData;
import be.eliwan.profiling.api.ProfilingBean;
import be.eliwan.profiling.api.ProfilingData;
import be.eliwan.profiling.api.ProfilingSink;
import be.eliwan.profiling.service.GroupContainer;
import be.eliwan.profiling.service.OneContainer;
import be.eliwan.profiling.service.Registration;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class ProfilingContainer
implements ProfilingBean,
ProfilingSink {
    private static final OneContainer CLEAR = new OneContainer(0L, 0L);
    private static final GroupDataComparator GROUP_DATA_COMPARATOR = new GroupDataComparator();
    private int ringSize = 1024;
    private ExecutorService executorService;
    private Disruptor<Registration> disruptor;
    private RingBuffer<Registration> ringBuffer;
    private final Map<String, OneContainerContainer> groupData = new ConcurrentHashMap<String, OneContainerContainer>();
    private OneContainer total = CLEAR;

    public void setRingSize(int ringSize) {
        this.ringSize = ringSize;
    }

    @PostConstruct
    public void start() {
        this.executorService = Executors.newCachedThreadPool();
        this.disruptor = new Disruptor(Registration.FACTORY, (Executor)this.executorService, (ClaimStrategy)new MultiThreadedClaimStrategy(this.ringSize), (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{new ContainerEventHandler()});
        this.ringBuffer = this.disruptor.start();
    }

    @PreDestroy
    public void shutdown() {
        this.disruptor.shutdown();
        this.executorService.shutdownNow();
    }

    public void clear() {
        this.register("", -1L);
    }

    public void register(String group, long duration) {
        if (null == group) {
            group = "";
        }
        long sequence = this.ringBuffer.next();
        Registration registration = (Registration)this.ringBuffer.get(sequence);
        registration.setGroup(group);
        registration.setDuration(duration);
        this.ringBuffer.publish(sequence);
    }

    public List<GroupData> getGroupData() {
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        boolean done = false;
        while (!done) {
            try {
                for (Map.Entry<String, OneContainerContainer> entry : this.groupData.entrySet()) {
                    OneContainer gv = entry.getValue().getValue();
                    GroupContainer gd = new GroupContainer(entry.getKey(), gv.getInvocationCount(), gv.getTotalRunTime());
                    result.add(gd);
                }
                done = true;
            }
            catch (ConcurrentModificationException cme) {
                result.clear();
            }
        }
        Collections.sort(result, GROUP_DATA_COMPARATOR);
        return result;
    }

    public ProfilingData getTotal() {
        return this.total;
    }

    private static class OneContainerContainer {
        private OneContainer value;

        private OneContainerContainer() {
        }

        public OneContainer getValue() {
            return this.value;
        }

        public void setValue(OneContainer value) {
            this.value = value;
        }
    }

    private static class GroupDataComparator
    implements Comparator<GroupData> {
        private GroupDataComparator() {
        }

        @Override
        public int compare(GroupData left, GroupData right) {
            return left.getGroup().compareTo(right.getGroup());
        }
    }

    private class ContainerEventHandler
    implements EventHandler<Registration> {
        private ContainerEventHandler() {
        }

        public void onEvent(Registration registration, long sequence, boolean endOfBatch) throws Exception {
            String group = registration.getGroup();
            long duration = registration.getDuration();
            if (duration < 0L) {
                ProfilingContainer.this.groupData.clear();
                ProfilingContainer.this.total = CLEAR;
            } else {
                ProfilingContainer.this.total = new OneContainer(ProfilingContainer.this.total.getInvocationCount() + 1L, ProfilingContainer.this.total.getTotalRunTime() + duration);
                OneContainerContainer container = (OneContainerContainer)ProfilingContainer.this.groupData.get(group);
                if (null == container) {
                    container = new OneContainerContainer();
                    container.setValue(new OneContainer(1L, duration));
                    ProfilingContainer.this.groupData.put(group, container);
                } else {
                    OneContainer gd = container.getValue();
                    container.setValue(new OneContainer(gd.getInvocationCount() + 1L, gd.getTotalRunTime() + duration));
                }
            }
        }
    }
}

