/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Status {
    public String getValue();

    public static final class Factory {
        private static final Logger LOGGER = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static Status of(String status) {
            try {
                return Default.valueOf(status.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Not a default status, returning a BasicStatus");
                return new BasicStatus(status);
            }
        }
    }

    public static class BasicStatus
    implements Status {
        private final String value;

        public BasicStatus(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Default implements Status
    {
        VALIDATED("validated"),
        RENEW_PROHIBITED("renew prohibited"),
        UPDATE_PROHIBITED("update prohibited"),
        TRANSFER_PROHIBITED("transfer prohibited"),
        DELETE_PROHIBITED("delete prohibited"),
        PROXY("proxy"),
        PRIVATE("private"),
        REMOVED("removed"),
        OBSCURED("obscured"),
        ASSOCIATED("associated"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        LOCKED("locked"),
        PENDING_CREATE("pending create"),
        PENDING_RENEW("pending renew"),
        PENDING_TRANSFER("pending transfer"),
        PENDING_UPDATE("pending update"),
        PENDING_DELETE("pending delete");

        private final String value;

        private Default(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

