/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TelephoneNumber {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelephoneNumber.class);
    private static final Properties COUNTRY_CODES = new Properties();
    private final int countryCode;
    private final BigInteger nationalNumber;

    public static String getRegion(int countryCode) {
        return COUNTRY_CODES.getProperty(Integer.toString(countryCode));
    }

    private TelephoneNumber(int countryCode, BigInteger nationalNumber) {
        Preconditions.checkArgument((countryCode >= 0 && countryCode < 1000 ? 1 : 0) != 0, (String)"countryCode %s must be between 0 and 999", (Object[])new Object[]{countryCode});
        Preconditions.checkArgument(((countryCode + nationalNumber.toString()).length() <= 15 ? 1 : 0) != 0, (Object)"TelephoneNumber maximum 15 digits long");
        Preconditions.checkArgument((TelephoneNumber.getRegion(countryCode) != null ? 1 : 0) != 0, (String)"unknown countryCode: %s", (Object[])new Object[]{countryCode});
        this.countryCode = countryCode;
        this.nationalNumber = new BigInteger(nationalNumber.toByteArray());
    }

    public static TelephoneNumber of(String number) {
        String normalized = number.replaceAll("[\\(\\)\\.\\s-_]", "");
        LOGGER.debug("Normalized telephone number: {}", (Object)normalized);
        if (!normalized.matches("^\\+?\\d+$")) {
            throw new IllegalArgumentException("bad number");
        }
        String prefix = "";
        String suffix = "";
        if (normalized.startsWith("+")) {
            for (int i = 1; i <= 3; ++i) {
                prefix = normalized.substring(1, i);
                suffix = normalized.substring(i);
                LOGGER.debug("prefix: {} suffix: {}", (Object)prefix, (Object)suffix);
                if (!COUNTRY_CODES.containsKey(prefix)) {
                    continue;
                }
                break;
            }
        } else {
            prefix = "0";
            suffix = normalized;
        }
        return new TelephoneNumber(Integer.valueOf(prefix), new BigInteger(suffix));
    }

    public static TelephoneNumber of(int countryCode, BigInteger nationalNumber) {
        return new TelephoneNumber(countryCode, nationalNumber);
    }

    public int getCountryCode() {
        return this.countryCode;
    }

    public BigInteger getNationalNumber() {
        return new BigInteger(this.nationalNumber.toByteArray());
    }

    public String getRegion() {
        return TelephoneNumber.getRegion(this.countryCode);
    }

    public String getStringValue() {
        return "+" + this.countryCode + "." + this.nationalNumber;
    }

    public String toString() {
        return "countryCode=[" + this.countryCode + "] nationalNumber=[" + this.nationalNumber + "]";
    }

    static {
        try {
            COUNTRY_CODES.load(TelephoneNumber.class.getResourceAsStream("country_calling_codes.csv"));
        }
        catch (IOException e) {
            LOGGER.error("Could not load country calling codes", (Throwable)e);
        }
    }
}

