/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.rdap.jackson.DateTimeSerializer;
import be.dnsbelgium.rdap.jackson.DomainNameSerializer;
import be.dnsbelgium.rdap.jackson.EntityRoleSerializer;
import be.dnsbelgium.rdap.jackson.EventActionSerializer;
import be.dnsbelgium.rdap.jackson.RDAPContactSerializer;
import be.dnsbelgium.rdap.jackson.StatusSerializer;
import be.dnsbelgium.rdap.jackson.StructuredValueSerializer;
import be.dnsbelgium.rdap.jackson.TextListSerializer;
import be.dnsbelgium.rdap.jackson.TextSerializer;
import be.dnsbelgium.rdap.jackson.URIValueSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;

public class CustomObjectMapper
extends ObjectMapper {
    public CustomObjectMapper() {
        super.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null, null, null));
        simpleModule.addSerializer((JsonSerializer)new RDAPContactSerializer());
        simpleModule.addSerializer((JsonSerializer)new StructuredValueSerializer());
        simpleModule.addSerializer((JsonSerializer)new TextListSerializer());
        simpleModule.addSerializer((JsonSerializer)new TextSerializer());
        simpleModule.addSerializer((JsonSerializer)new URIValueSerializer());
        simpleModule.addSerializer((JsonSerializer)new DomainNameSerializer());
        simpleModule.addSerializer((JsonSerializer)new DateTimeSerializer());
        simpleModule.addSerializer((JsonSerializer)new StatusSerializer());
        simpleModule.addSerializer((JsonSerializer)new EntityRoleSerializer());
        simpleModule.addSerializer((JsonSerializer)new EventActionSerializer());
        for (JsonSerializer serializer : this.getSerializers()) {
            simpleModule.addSerializer(serializer);
        }
        this.registerModule((Module)simpleModule);
    }

    public List<JsonSerializer> getSerializers() {
        return new ArrayList<JsonSerializer>();
    }
}

