/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Common;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Link;
import be.dnsbelgium.rdap.core.Notice;
import be.dnsbelgium.rdap.core.PublicId;
import be.dnsbelgium.rdap.core.Status;
import be.dnsbelgium.vcard.Contact;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;

public final class Entity
extends Common {
    public static final String OBJECT_CLASS_NAME = "entity";
    private final String handle;
    private final Contact vcardArray;
    private final List<Role> roles;
    private final List<Event> asEventActor;
    private final List<PublicId> publicIds;
    private List<Entity> entities;

    @JsonCreator
    public Entity(@JsonProperty(value="links") List<Link> links, @JsonProperty(value="notices") List<Notice> notices, @JsonProperty(value="remarks") List<Notice> remarks, @JsonProperty(value="lang") String lang, @JsonProperty(value="objectClassName") String objectClassName, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="status") List<Status> status, @JsonProperty(value="port43") DomainName port43, @JsonProperty(value="handle") String handle, @JsonProperty(value="vcardArray") Contact vcardArray, @JsonProperty(value="roles") List<Role> roles, @JsonProperty(value="asEventActor") List<Event> asEventActor, @JsonProperty(value="publicIds") List<PublicId> publicIds, @JsonProperty(value="entities") List<Entity> entities) {
        super(links, notices, remarks, lang, objectClassName, events, status, port43);
        this.handle = handle;
        this.vcardArray = vcardArray;
        this.roles = roles == null ? null : new ImmutableList.Builder().addAll(roles).build();
        this.asEventActor = asEventActor == null ? null : new ImmutableList.Builder().addAll(asEventActor).build();
        this.publicIds = publicIds == null ? null : new ImmutableList.Builder().addAll(publicIds).build();
        this.entities = entities == null ? null : new ImmutableList.Builder().addAll(entities).build();
    }

    public String getHandle() {
        return this.handle;
    }

    public Contact getvcardArray() {
        return this.vcardArray;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public List<Event> getAsEventActor() {
        return this.asEventActor;
    }

    public List<PublicId> getPublicIds() {
        return this.publicIds;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public static interface Role {
        public String getValue();

        public static class BasicRole
        implements Role {
            private final String value;

            public BasicRole(String value) {
                this.value = value;
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }

        public static enum Default implements Role
        {
            REGISTRANT,
            TECHNICAL,
            ADMINISTRATIVE,
            ABUSE,
            BILLING,
            REGISTRAR,
            RESELLER,
            SPONSOR,
            PROXY,
            NOTIFICATIONS,
            NOC;

            private final String value = this.name().toLowerCase(Locale.ENGLISH);

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }
}

