/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.vcard.datatype;

import be.dnsbelgium.vcard.datatype.Text;
import be.dnsbelgium.vcard.datatype.Value;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class AbstractList<T extends Value>
implements Value {
    public final List<T> values;

    public AbstractList(List<T> values) {
        this.values = values == null ? null : new ImmutableList.Builder().addAll(values).build();
    }

    public List<T> getValues() {
        return this.values;
    }

    public static class TextList
    extends AbstractList<Text> {
        public TextList(List<Text> values) {
            super(values);
        }

        public static TextList of(List<String> values) {
            if (values == null) {
                return new TextList(null);
            }
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (String value : values) {
                builder.add((Object)new Text(value));
            }
            return new TextList((List<Text>)builder.build());
        }

        @Override
        public String getTypeName() {
            return "text";
        }
    }
}

