/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.vcard.datatype.AbstractList;
import be.dnsbelgium.vcard.datatype.StructuredValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredValueSerializer
extends JsonSerializer<StructuredValue> {
    public static final Logger LOGGER = LoggerFactory.getLogger(StructuredValueSerializer.class);

    public Class<StructuredValue> handledType() {
        return StructuredValue.class;
    }

    public void serialize(StructuredValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.getComponents().length > 1) {
            jgen.writeStartArray();
        }
        for (StructuredValue.Component c : value.getComponents()) {
            if (AbstractList.class.isAssignableFrom(c.value.getClass()) && ((AbstractList)c.value).getValues() != null && ((AbstractList)c.value).getValues().size() > 1) {
                jgen.writeStartArray();
                provider.findValueSerializer(c.value.getClass(), null).serialize(c.value, jgen, provider);
                jgen.writeEndArray();
                continue;
            }
            provider.findValueSerializer(c.value.getClass(), null).serialize(c.value, jgen, provider);
        }
        if (value.getComponents().length > 1) {
            jgen.writeEndArray();
        }
    }
}

