/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.vcard.datatype;

import be.dnsbelgium.core.TelephoneNumber;
import be.dnsbelgium.vcard.datatype.AbstractList;
import be.dnsbelgium.vcard.datatype.Tel;
import be.dnsbelgium.vcard.datatype.Text;
import be.dnsbelgium.vcard.datatype.URIValue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public interface Value {
    public String getTypeName();

    public static final class Factory {
        private Factory() {
        }

        public static Value of(String value) {
            return Text.of(value);
        }

        public static Value of(TelephoneNumber value) throws URISyntaxException {
            return new Tel(value);
        }

        public static Value of(URI value) {
            return new URIValue(value);
        }

        public static Value of(Iterable<String> value) {
            ArrayList<Text> list = new ArrayList<Text>();
            for (String str : value) {
                list.add(Text.of(str));
            }
            return new AbstractList.TextList((List<Text>)list);
        }
    }
}

