/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.vcard.Contact;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactSerializer
extends JsonSerializer<Contact> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactSerializer.class);

    public Class<Contact> handledType() {
        return Contact.class;
    }

    public void serialize(Contact contact, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartArray();
        jsonGenerator.writeStartArray();
        jsonGenerator.writeString("version");
        jsonGenerator.writeStartObject();
        jsonGenerator.writeEndObject();
        jsonGenerator.writeString("text");
        jsonGenerator.writeString("4.0");
        jsonGenerator.writeEndArray();
        for (Contact.Property property : contact.getProperties()) {
            jsonGenerator.writeStartArray();
            String key = property.getGroup() == null ? property.getName() : property.getGroup() + "." + property.getName();
            jsonGenerator.writeString(property.getName().toLowerCase(Locale.ENGLISH));
            jsonGenerator.writeStartObject();
            if (property.getGroup() != null) {
                jsonGenerator.writeFieldName("group");
                jsonGenerator.writeString(property.getGroup());
            }
            if (property.getParameters() != null) {
                Iterator<String> it = property.getParameters().keys();
                while (it.hasNext()) {
                    Set<String> values;
                    String k = it.next();
                    if (k.equalsIgnoreCase("value") || (values = property.getParameters().get(k)).size() == 0) continue;
                    jsonGenerator.writeFieldName(k.toLowerCase(Locale.ENGLISH));
                    if (values.size() == 1) {
                        jsonGenerator.writeString(values.toArray(new String[values.size()])[0]);
                        continue;
                    }
                    jsonGenerator.writeStartArray();
                    for (String str : property.getParameters().get(k)) {
                        jsonGenerator.writeString(str);
                    }
                    jsonGenerator.writeEndArray();
                }
            }
            jsonGenerator.writeEndObject();
            String value = "text";
            if (property.getValue() != null && property.getValue().getTypeName() != null) {
                value = property.getValue().getTypeName();
            }
            jsonGenerator.writeString(value);
            JsonSerializer s = serializerProvider.findValueSerializer(property.getValue().getClass(), null);
            s.serialize(property.getValue(), jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndArray();
    }

    public void serializeWithType(Contact value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        super.serializeWithType((Object)value, jgen, provider, typeSer);
    }
}

