/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public class RDAPError
extends Exception {
    private static final long serialVersionUID = 3000647771812593816L;
    private final int errorCode;
    private final String title;
    private final List<String> description;

    @JsonCreator
    public RDAPError(@JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="title") String title, @JsonProperty(value="description") List<String> description) {
        this.errorCode = errorCode;
        this.title = title;
        this.description = description == null ? null : new ImmutableList.Builder().addAll(description).build();
    }

    @JsonCreator
    public RDAPError(@JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description) {
        this(errorCode, title, description == null ? null : Arrays.asList(description));
    }

    @JsonCreator
    public RDAPError(@JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="title") String title) {
        this(errorCode, title, (List<String>)null);
    }

    public RDAPError(int errorCode, String title, List<String> description, Throwable cause) {
        this(errorCode, title, description);
        this.initCause(cause);
    }

    @JsonProperty
    public int getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public List<String> getDescription() {
        return this.description;
    }

    public static DomainNotFound domainNotFound(DomainName domainName) {
        return new DomainNotFound(domainName);
    }

    public static AutNumNotFound autNumNotFound(int autNum) {
        return new AutNumNotFound(autNum);
    }

    public static BadRequest badRequest(String title, String description) {
        return new BadRequest(title, description);
    }

    public static BadRequest badRequest(String title, List<String> description) {
        return new BadRequest(title, description);
    }

    public static NotAuthoritative notAuthoritative(DomainName domainName) {
        return new NotAuthoritative(domainName.getStringValue());
    }

    public static RDAPError entityNotFound(String handle) {
        return new EntityNotFound(handle);
    }

    public static RDAPError helpNotFound() {
        return new HelpNotFound();
    }

    public static RDAPError ipNotFound(String ipAddress) {
        return new IPNotFound(ipAddress);
    }

    public static RDAPError nameserverNotFound(DomainName domainName) {
        return new NameserverNotFound(domainName);
    }

    public static RDAPError notImplemented() {
        return new NotImplemented();
    }

    public static RDAPError noResults(String query) {
        return new NoResults(query);
    }

    public static RDAPError methodNotAllowed() {
        return new MethodNotAllowed();
    }

    public static class MethodNotAllowed
    extends RDAPError {
        private static final long serialVersionUID = 1428932048414525660L;

        private MethodNotAllowed() {
            super(405, "Method not allowed");
        }
    }

    public static class NotAuthoritative
    extends RDAPError {
        private static final long serialVersionUID = 7010767440479876394L;
        private String domainName;

        private NotAuthoritative(String domainName) {
            super(301, String.format("Not authoritative for %s", domainName));
            this.domainName = domainName;
        }

        public String getDomainName() {
            return this.domainName;
        }
    }

    public static class DomainNotFound
    extends RDAPError {
        private static final long serialVersionUID = -1355753652647945804L;
        private final DomainName domainName;

        private DomainNotFound(DomainName domainName) {
            super(404, String.format("Domain %s not found", domainName.toLDH().getStringValue()));
            this.domainName = domainName;
        }

        public DomainName getDomainName() {
            return this.domainName;
        }
    }

    public static class NameserverNotFound
    extends RDAPError {
        private static final long serialVersionUID = -3617347189246764940L;
        private final DomainName nameserverName;

        private NameserverNotFound(DomainName nameserverName) {
            super(404, String.format("Nameserver %s not found", nameserverName.toLDH().getStringValue()));
            this.nameserverName = nameserverName;
        }

        public DomainName getNameserverName() {
            return this.nameserverName;
        }
    }

    public static class EntityNotFound
    extends RDAPError {
        private static final long serialVersionUID = -5264750084274730969L;
        private final String handle;

        private EntityNotFound(String handle) {
            super(404, String.format("Entity %s not found", handle));
            this.handle = handle;
        }

        public String getHandle() {
            return this.handle;
        }
    }

    public static class IPNotFound
    extends RDAPError {
        private static final long serialVersionUID = -7523573051976600864L;
        private final String ipAddress;

        private IPNotFound(String ipAddress) {
            super(404, String.format("IP %s not found", ipAddress));
            this.ipAddress = ipAddress;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }
    }

    public static class AutNumNotFound
    extends RDAPError {
        private static final long serialVersionUID = 3356523501894745257L;
        private final int autNum;

        private AutNumNotFound(int autNum) {
            super(404, String.format("AutNum %s not found", autNum));
            this.autNum = autNum;
        }

        public int getAutNum() {
            return this.autNum;
        }
    }

    public static class NotImplemented
    extends RDAPError {
        private static final long serialVersionUID = 1908478239735418778L;

        private NotImplemented() {
            super(501, "Not implemented");
        }
    }

    public static class HelpNotFound
    extends RDAPError {
        private static final long serialVersionUID = -2365389916154054286L;

        private HelpNotFound() {
            super(404, "Help not found");
        }
    }

    public static class BadRequest
    extends RDAPError {
        private static final long serialVersionUID = -7970785038966067523L;

        private BadRequest(String title, String description) {
            super(400, title, description);
        }

        private BadRequest(String title, List<String> description) {
            super(400, title, description);
        }
    }

    public static class NoResults
    extends RDAPError {
        private static final long serialVersionUID = -3752099182358813007L;

        private NoResults(String query) {
            super(404, String.format("No results for query %s", query));
        }
    }
}

