/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.rdap.core.Link;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;

public class Event {
    private final Action eventAction;
    private final String eventActor;
    private final DateTime eventDate;
    private final List<Link> links;

    public Event(@JsonProperty(value="eventAction") Action eventAction, @JsonProperty(value="eventActor") String eventActor, @JsonProperty(value="eventDate") DateTime eventDate, @JsonProperty(value="links") List<Link> links) {
        this.eventAction = eventAction;
        this.eventActor = eventActor;
        this.eventDate = eventDate;
        this.links = links == null ? null : new ImmutableList.Builder().addAll(links).build();
    }

    public Action getEventAction() {
        return this.eventAction;
    }

    public String getEventActor() {
        return this.eventActor;
    }

    public DateTime getEventDate() {
        return this.eventDate;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public static interface Action {
        public String getValue();

        public static enum Default implements Action
        {
            REGISTRATION,
            REREGISTRATION,
            LAST_CHANGED{

                @Override
                public String getValue() {
                    return "last changed";
                }
            }
            ,
            EXPIRATION,
            DELETION,
            REINSTANTIATION,
            TRANSFER,
            LOCKED,
            UNLOCKED,
            LAST_UPDATE_OF_RDAP_DATABASE{

                @Override
                public String getValue() {
                    return "last update of RDAP database";
                }
            };

            private final String value = this.name().toLowerCase(Locale.ENGLISH);

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }
}

