/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Common;
import be.dnsbelgium.rdap.core.Entity;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.IPNetwork;
import be.dnsbelgium.rdap.core.Link;
import be.dnsbelgium.rdap.core.Nameserver;
import be.dnsbelgium.rdap.core.Notice;
import be.dnsbelgium.rdap.core.PublicId;
import be.dnsbelgium.rdap.core.SecureDNS;
import be.dnsbelgium.rdap.core.Status;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Domain
extends Common {
    public static final String OBJECT_CLASS_NAME = "domain";
    public String handle;
    public DomainName ldhName;
    public DomainName unicodeName;
    public List<Variant> variants;
    public List<Nameserver> nameservers;
    public SecureDNS secureDNS;
    public List<Entity> entities;
    public List<PublicId> publicIds;
    public IPNetwork network;

    public List<PublicId> getPublicIds() {
        return this.publicIds;
    }

    public Domain(@JsonProperty(value="links") List<Link> links, @JsonProperty(value="notices") List<Notice> notices, @JsonProperty(value="remarks") List<Notice> remarks, @JsonProperty(value="lang") String lang, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="status") List<Status> status, @JsonProperty(value="port43") DomainName port43, @JsonProperty(value="handle") String handle, @JsonProperty(value="ldhName") DomainName ldhName, @JsonProperty(value="unicodeName") DomainName unicodeName, @JsonProperty(value="variants") List<Variant> variants, @JsonProperty(value="nameServers") List<Nameserver> nameservers, @JsonProperty(value="secureDNS") SecureDNS secureDNS, @JsonProperty(value="entities") List<Entity> entities, @JsonProperty(value="publicIds") List<PublicId> publicIds, @JsonProperty(value="network") IPNetwork network) {
        super(links, notices, remarks, lang, OBJECT_CLASS_NAME, events, status, port43);
        this.handle = handle;
        this.ldhName = ldhName;
        this.unicodeName = unicodeName;
        this.variants = variants == null ? null : new ImmutableList.Builder().addAll(variants).build();
        this.nameservers = nameservers == null ? null : new ImmutableList.Builder().addAll(nameservers).build();
        this.secureDNS = secureDNS;
        this.entities = entities == null ? null : new ImmutableList.Builder().addAll(entities).build();
        this.publicIds = publicIds == null ? null : new ImmutableList.Builder().addAll(publicIds).build();
        this.network = network;
    }

    public static final class Variant {
        private final List<Relation> relations;
        private final String idnTable;
        private final List<Name> variantNames;

        @JsonCreator
        public Variant(@JsonProperty(value="relation") List<Relation> relations, @JsonProperty(value="idnTable") String idnTable, @JsonProperty(value="variantNames") List<Name> variantNames) {
            this.relations = new ImmutableList.Builder().addAll(relations).build();
            this.idnTable = idnTable;
            this.variantNames = new ImmutableList.Builder().addAll(variantNames).build();
        }

        public List<Relation> getRelations() {
            return this.relations;
        }

        public List<Name> getVariantNames() {
            return this.variantNames;
        }

        public static class Name {
            private final DomainName ldhName;
            private final DomainName unicodeName;

            @JsonCreator
            public Name(@JsonProperty(value="ldhName") DomainName ldhName, @JsonProperty(value="unicodeName") DomainName unicodeName) {
                this.ldhName = ldhName;
                this.unicodeName = unicodeName;
            }

            public DomainName getLdhName() {
                return this.ldhName;
            }

            public DomainName getUnicodeName() {
                return this.unicodeName;
            }
        }

        public static interface Relation {
            public String getValue();

            public static class BasicRelation
            implements Relation {
                private final String value;

                public BasicRelation(String value) {
                    this.value = value;
                }

                @Override
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Default implements Relation
            {
                REGISTERED("registered"),
                UNREGISTERED("unregistered"),
                RESTRICTED_REGISTRATION("restricted registration"),
                OPEN_REGISTRATION("open registration"),
                CONJOINED("conjoined");

                private final String value;

                private Default(String value) {
                    this.value = value;
                }

                @Override
                public String getValue() {
                    return this.value;
                }
            }

            public static final class Factory {
                private static final Logger LOGGER = LoggerFactory.getLogger(Factory.class);

                private Factory() {
                }

                public static Relation of(String relation) {
                    try {
                        return Default.valueOf(relation.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("Not a standard relation", (Throwable)iae);
                        return new BasicRelation(relation);
                    }
                }
            }
        }
    }
}

