/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Link;
import be.dnsbelgium.rdap.core.Notice;
import be.dnsbelgium.rdap.core.Status;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonPropertyOrder(value={"rdapConformance", "objectClassName"})
class Common {
    public static final String DEFAULT_RDAP_CONFORMANCE = "rdap_level_0";
    public Set<String> rdapConformance;
    public List<Link> links;
    public List<Notice> notices;
    public List<Notice> remarks;
    public String lang;
    public String objectClassName;
    public List<Event> events;
    public List<Status> status;
    public DomainName port43;

    @JsonCreator
    public Common(@JsonProperty(value="links") List<Link> links, @JsonProperty(value="notices") List<Notice> notices, @JsonProperty(value="remarks") List<Notice> remarks, @JsonProperty(value="lang") String lang, @JsonProperty(value="objectClassName") String objectClassName, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="status") List<Status> status, @JsonProperty(value="port43") DomainName port43) {
        this.links = links == null ? null : new ImmutableList.Builder().addAll(links).build();
        this.notices = notices == null ? null : new ImmutableList.Builder().addAll(notices).build();
        this.remarks = remarks == null ? null : new ImmutableList.Builder().addAll(remarks).build();
        this.lang = lang;
        this.objectClassName = objectClassName;
        this.events = events == null ? null : new ImmutableList.Builder().addAll(events).build();
        this.status = status == null ? null : new ImmutableList.Builder().addAll(status).build();
        this.port43 = port43;
    }

    public void addRdapConformance(String conformance) {
        if (this.rdapConformance == null) {
            this.rdapConformance = new HashSet<String>();
        }
        this.rdapConformance.add(conformance);
    }

    public Set<String> getRdapConformance() {
        return this.rdapConformance;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public List<Notice> getNotices() {
        return this.notices;
    }

    public List<Notice> getRemarks() {
        return this.remarks;
    }

    public String getLang() {
        return this.lang;
    }

    public String getObjectClassName() {
        return this.objectClassName;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<Status> getStatus() {
        return this.status;
    }

    public DomainName getPort43() {
        return this.port43;
    }
}

