/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.core;

import be.dnsbelgium.core.LabelException;
import be.dnsbelgium.core.TelephoneNumber;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Label {
    public static final Logger LOGGER;
    public static final int IDNA_OPTIONS;
    private static final IDNA IDNA;
    private static final String HYPHEN = "-";
    private final String value;

    public Label(String value) {
        this.value = value;
    }

    public static Label of(String label) {
        if (StringUtils.isEmpty((CharSequence)label)) {
            return RootLabel.getInstance();
        }
        if (!ASCIILabel.ASCII_SET.containsAll(label)) {
            IDNA.Info info = new IDNA.Info();
            StringBuilder result = new StringBuilder();
            IDNA.labelToUnicode((CharSequence)label, result, info);
            if (info.hasErrors()) {
                throw new LabelException.IDNParseException(info.getErrors());
            }
            return new NonASCIILabel.ULabel(result.toString());
        }
        if (!ASCIILabel.LDHLabel.LDH_SET.containsAll(label) || label.startsWith(HYPHEN) || label.endsWith(HYPHEN)) {
            return new ASCIILabel.NONLDHLabel(label);
        }
        if (!label.matches("^..--.*")) {
            return new ASCIILabel.LDHLabel.NonReservedLDHLabel(label);
        }
        if (label.startsWith("xn")) {
            ASCIILabel.LDHLabel.ReservedLDHLabel.ALabel aLabel = new ASCIILabel.LDHLabel.ReservedLDHLabel.ALabel(label);
            try {
                ((Label)aLabel).toUnicode();
                return aLabel;
            }
            catch (LabelException.IDNParseException e) {
                LOGGER.debug("Fake A-Label", (Throwable)e);
                return new ASCIILabel.LDHLabel.ReservedLDHLabel.FakeALabel(label, e.getErrors());
            }
        }
        return new ASCIILabel.LDHLabel.ReservedLDHLabel(label);
    }

    public String getStringValue() {
        return this.value;
    }

    public Label toLDH() {
        return this;
    }

    public Label toUnicode() {
        return this;
    }

    static {
        int options;
        LOGGER = LoggerFactory.getLogger(Label.class);
        Properties properties = new Properties();
        try {
            properties.load(TelephoneNumber.class.getResourceAsStream("icu4j.properties"));
            options = Integer.parseInt(properties.getProperty("idna.options"));
        }
        catch (IOException e) {
            LOGGER.debug("IOException. Defaulting to zero", (Throwable)e);
            options = 0;
        }
        IDNA_OPTIONS = options;
        IDNA = com.ibm.icu.text.IDNA.getUTS46Instance((int)IDNA_OPTIONS);
    }

    public static class RootLabel
    extends Label {
        private static final RootLabel INSTANCE = new RootLabel();

        private RootLabel() {
            super("");
        }

        public static RootLabel getInstance() {
            return INSTANCE;
        }
    }

    public static abstract class NonASCIILabel
    extends Label {
        private NonASCIILabel(String value) {
            super(value);
        }

        public static class ULabel
        extends NonASCIILabel {
            private ULabel(String value) {
                super(value);
            }

            @Override
            public Label toLDH() {
                IDNA.Info info = new IDNA.Info();
                StringBuilder result = new StringBuilder();
                IDNA.labelToASCII((CharSequence)this.getStringValue(), result, info);
                if (info.hasErrors()) {
                    throw new LabelException.IDNParseException(info.getErrors());
                }
                return Label.of(result.toString());
            }
        }
    }

    public static abstract class ASCIILabel
    extends Label {
        public static final UnicodeSet ASCII_SET = new UnicodeSet().set(32, 127);

        private ASCIILabel(String value) {
            super(value);
            if (!ASCII_SET.containsAll(value)) {
                throw new IllegalArgumentException();
            }
        }

        public static class NONLDHLabel
        extends ASCIILabel {
            private NONLDHLabel(String value) {
                super(value);
            }
        }

        public static abstract class LDHLabel
        extends ASCIILabel {
            public static final UnicodeSet LDH_SET = new UnicodeSet().applyPattern("[A-Za-z0-9\\-]");

            private LDHLabel(String value) {
                super(value);
            }

            public static class NonReservedLDHLabel
            extends LDHLabel {
                private NonReservedLDHLabel(String value) {
                    super(value);
                }
            }

            public static class ReservedLDHLabel
            extends LDHLabel {
                private ReservedLDHLabel(String value) {
                    super(value);
                    if (!LDH_SET.containsAll(value)) {
                        throw new IllegalArgumentException();
                    }
                }

                public static class FakeALabel
                extends ReservedLDHLabel {
                    private Set<IDNA.Error> errors;

                    private FakeALabel(String value, Set<IDNA.Error> errors) {
                        super(value);
                        this.errors = new ImmutableSet.Builder().addAll(errors).build();
                    }

                    public Set<IDNA.Error> getErrors() {
                        return this.errors;
                    }
                }

                public static class ALabel
                extends ReservedLDHLabel {
                    private ALabel(String value) {
                        super(value);
                    }

                    @Override
                    public Label toUnicode() {
                        IDNA.Info info = new IDNA.Info();
                        StringBuilder result = new StringBuilder();
                        IDNA.labelToUnicode((CharSequence)this.getStringValue(), result, info);
                        if (info.hasErrors()) {
                            throw new LabelException.IDNParseException(info.getErrors());
                        }
                        return Label.of(result.toString());
                    }
                }
            }
        }
    }
}

