/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.core;

import be.dnsbelgium.core.Label;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DomainName {
    private final List<Label> labels;

    public DomainName(List<Label> labels) {
        Preconditions.checkNotNull(labels, (Object)"labels must not be null");
        Preconditions.checkArgument((labels.size() > 0 ? 1 : 0) != 0, (Object)"labels.size() should be > 0");
        for (int i = 0; i < labels.size() - 1; ++i) {
            if (!(labels.get(i) instanceof Label.RootLabel)) continue;
            throw new IllegalArgumentException("Only the last label may be a root label");
        }
        this.labels = new ImmutableList.Builder().addAll(labels).build();
    }

    public static DomainName of(String domainName) {
        String[] labels = StringUtils.splitPreserveAllTokens((String)domainName, (char)'.');
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String label : labels) {
            builder.add((Object)Label.of(label));
        }
        return new DomainName((List<Label>)builder.build());
    }

    public DomainName toFQDN() {
        if (this.isFQDN()) {
            return this;
        }
        return new DomainName((List<Label>)new ImmutableList.Builder().addAll(this.labels).add((Object)Label.RootLabel.getInstance()).build());
    }

    public boolean isFQDN() {
        return this.labels.get(this.labels.size() - 1) instanceof Label.RootLabel;
    }

    public int getLevelSize() {
        return this.isFQDN() ? this.labels.size() - 1 : this.labels.size();
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public Label getTLDLabel() {
        return this.labels.get(this.getLevelSize() - 1);
    }

    public String getStringValue() {
        StringBuffer sb = new StringBuffer(this.labels.get(0).getStringValue());
        for (int i = 1; i < this.labels.size(); ++i) {
            sb.append("." + this.labels.get(i).getStringValue());
        }
        return sb.toString();
    }

    public Label getLevel(int level) {
        if (this.isFQDN()) {
            return this.labels.get(this.labels.size() - 1 - level);
        }
        return this.labels.get(this.labels.size() - level);
    }

    public DomainName toLDH() {
        ArrayList<Label> labelList = new ArrayList<Label>();
        for (Label label : this.getLabels()) {
            labelList.add(label.toLDH());
        }
        return new DomainName(labelList);
    }

    public DomainName toUnicode() {
        ArrayList<Label> labelList = new ArrayList<Label>();
        for (Label label : this.getLabels()) {
            labelList.add(label.toUnicode());
        }
        return new DomainName(labelList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomainName)) {
            return false;
        }
        DomainName that = (DomainName)o;
        return this.toLDH().getStringValue().equals(that.toLDH().getStringValue());
    }

    public int hashCode() {
        return this.toLDH().getStringValue().hashCode();
    }
}

