/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.vcard.datatype;

import be.dnsbelgium.vcard.datatype.Text;
import java.util.Locale;

public class LanguageTag
extends Text {
    public LanguageTag(String languageCode) {
        super(languageCode.toLowerCase(Locale.ENGLISH));
        if (!LanguageTag.isValidLanguageCode(languageCode)) {
            throw new IllegalArgumentException("invalid language code");
        }
    }

    private static boolean isValidLanguageCode(String languageCode) {
        for (String lang : Locale.getISOLanguages()) {
            if (!lang.equalsIgnoreCase(languageCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTypeName() {
        return "language-tag";
    }
}

