/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Link;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class SecureDNS {
    private final Boolean zoneSigned;
    private final Boolean delegationSigned;
    private final int maxSigLife;
    private final List<DSData> dsData;
    private final List<KeyData> keyData;

    @JsonCreator
    public SecureDNS(@JsonProperty(value="zoneSigned") Boolean zoneSigned, @JsonProperty(value="delegationSigned") Boolean delegationSigned, @JsonProperty(value="maxSigLife") int maxSigLife, @JsonProperty(value="dsData") List<DSData> dsData, @JsonProperty(value="keyData") List<KeyData> keyData) {
        this.zoneSigned = zoneSigned;
        this.delegationSigned = delegationSigned;
        this.maxSigLife = maxSigLife;
        this.dsData = dsData == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(dsData);
        this.keyData = keyData == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(keyData);
    }

    public Boolean isZoneSigned() {
        return this.zoneSigned;
    }

    public Boolean isDelegationSigned() {
        return this.delegationSigned;
    }

    public int getMaxSigLife() {
        return this.maxSigLife;
    }

    public List<DSData> getDsData() {
        return this.dsData;
    }

    public List<KeyData> getKeyData() {
        return this.keyData;
    }

    public static class KeyData {
        private final String flags;
        private final String protocol;
        private final String publicKey;
        private final int algorithm;
        private final List<Event> events;
        private final List<Link> links;

        @JsonCreator
        public KeyData(@JsonProperty(value="flags") String flags, @JsonProperty(value="protocol") String protocol, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="algorithm") int algorithm, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="links") List<Link> links) {
            this.flags = flags;
            this.protocol = protocol;
            this.publicKey = publicKey;
            this.algorithm = algorithm;
            this.events = events == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(events);
            this.links = links == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(links);
        }

        public String getFlags() {
            return this.flags;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public List<Link> getLinks() {
            return this.links;
        }
    }

    public static class DSData {
        private final int keyTag;
        private final int algorithm;
        private final String digest;
        private final int digestType;
        private final List<Event> events;
        private final List<Link> links;

        @JsonCreator
        public DSData(@JsonProperty(value="keyTag") int keyTag, @JsonProperty(value="algorithm") int algorithm, @JsonProperty(value="digest") String digest, @JsonProperty(value="digestType") int digestType, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="links") List<Link> links) {
            this.keyTag = keyTag;
            this.algorithm = algorithm;
            this.digest = digest;
            this.digestType = digestType;
            this.events = events == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(events);
            this.links = links == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(links);
        }

        public int getKeyTag() {
            return this.keyTag;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public String getDigest() {
            return this.digest;
        }

        public int getDigestType() {
            return this.digestType;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public List<Link> getLinks() {
            return this.links;
        }
    }
}

