/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.core;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static byte[] getMask(int m, int max_m) {
        byte[] b = new byte[max_m / 8];
        for (int i = 0; i < b.length; ++i) {
            b[i] = -1;
        }
        int j = b.length - 1;
        int k = 1;
        for (int i = 1; i <= max_m - m; ++i) {
            b[j] = (byte)(b[j] << 1 & 0xFF);
            if (++k <= 8) continue;
            k = 1;
            --j;
        }
        return b;
    }

    public static String byteArrayToString(byte[] b_array, boolean spaces) {
        String result = "";
        for (byte b : b_array) {
            result = result + (spaces ? " " : "") + ByteUtils.byteToString(b);
        }
        return result.trim();
    }

    public static String byteToString(byte b) {
        StringBuffer sb = new StringBuffer();
        for (int mask = 1; mask != 256; mask <<= 1) {
            boolean value = (b & mask) != 0;
            sb.insert(0, value ? "1" : "0");
        }
        return sb.toString();
    }

    public static byte[] and(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            throw new IllegalArgumentException("arrays should have isSame size");
        }
        byte[] result = new byte[b1.length];
        for (int i = 0; i < b1.length; ++i) {
            result[i] = (byte)(b1[i] & b2[i]);
        }
        return result;
    }

    public static boolean isSame(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            throw new IllegalArgumentException("arrays should have isSame size");
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

