/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.rdap.core.Entity;
import java.io.IOException;
import java.util.Locale;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDeserializer
extends JsonDeserializer<Entity.Role> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleDeserializer.class);

    public Entity.Role deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        final String value = jp.getText();
        try {
            return Entity.Role.Default.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Not a default role, returning a free text role", (Throwable)iae);
            return new Entity.Role(){

                @Override
                public String getValue() {
                    return value;
                }
            };
        }
    }
}

