/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDeserializer
extends JsonDeserializer<DateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeDeserializer.class);

    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getText() == null) {
            return null;
        }
        try {
            return DateTime.parse((String)jp.getText(), (DateTimeFormatter)ISODateTimeFormat.dateTimeNoMillis());
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warn(String.format("Cannot parse '%s' as ISO date. Returning null", jp.getText()), (Throwable)iae);
            return null;
        }
    }
}

