/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Domain;
import be.dnsbelgium.rdap.core.Entity;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Status;
import be.dnsbelgium.rdap.jackson.ActionDeserializer;
import be.dnsbelgium.rdap.jackson.ContactDeserializer;
import be.dnsbelgium.rdap.jackson.ContactSerializer;
import be.dnsbelgium.rdap.jackson.DateTimeDeserializer;
import be.dnsbelgium.rdap.jackson.DateTimeSerializer;
import be.dnsbelgium.rdap.jackson.DomainNameDeserializer;
import be.dnsbelgium.rdap.jackson.DomainNameSerializer;
import be.dnsbelgium.rdap.jackson.RelationDeserializer;
import be.dnsbelgium.rdap.jackson.RoleDeserializer;
import be.dnsbelgium.rdap.jackson.StatusDeserializer;
import be.dnsbelgium.rdap.jackson.StatusSerializer;
import be.dnsbelgium.rdap.jackson.StructuredValueSerializer;
import be.dnsbelgium.rdap.jackson.TextListSerializer;
import be.dnsbelgium.rdap.jackson.TextSerializer;
import be.dnsbelgium.rdap.jackson.URIValueSerializer;
import be.dnsbelgium.vcard.Contact;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.module.SimpleModule;
import org.joda.time.DateTime;

public class CustomObjectMapper
extends ObjectMapper {
    public CustomObjectMapper() {
        super.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.configure(SerializationConfig.Feature.WRITE_EMPTY_JSON_ARRAYS, false);
        SimpleModule simpleModule = new SimpleModule("SimpleModule", new Version(1, 0, 0, null));
        simpleModule.addSerializer((JsonSerializer)new ContactSerializer());
        simpleModule.addSerializer((JsonSerializer)new StructuredValueSerializer());
        simpleModule.addSerializer((JsonSerializer)new TextListSerializer());
        simpleModule.addSerializer((JsonSerializer)new TextSerializer());
        simpleModule.addSerializer((JsonSerializer)new URIValueSerializer());
        simpleModule.addSerializer((JsonSerializer)new DomainNameSerializer());
        simpleModule.addSerializer((JsonSerializer)new DateTimeSerializer());
        simpleModule.addSerializer((JsonSerializer)new StatusSerializer());
        for (JsonSerializer serializer : this.getSerializers()) {
            simpleModule.addSerializer(serializer);
        }
        simpleModule.addDeserializer(Contact.class, (JsonDeserializer)new ContactDeserializer());
        simpleModule.addDeserializer(DomainName.class, (JsonDeserializer)new DomainNameDeserializer());
        simpleModule.addDeserializer(Entity.Role.class, (JsonDeserializer)new RoleDeserializer());
        simpleModule.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        simpleModule.addDeserializer(Event.Action.class, (JsonDeserializer)new ActionDeserializer());
        simpleModule.addDeserializer(Status.class, (JsonDeserializer)new StatusDeserializer());
        simpleModule.addDeserializer(Domain.Variant.Relation.class, (JsonDeserializer)new RelationDeserializer());
        this.registerModule((Module)simpleModule);
    }

    public List<JsonSerializer> getSerializers() {
        return new ArrayList<JsonSerializer>();
    }
}

