/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Common;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Link;
import be.dnsbelgium.rdap.core.Notice;
import be.dnsbelgium.rdap.core.Status;
import com.google.common.collect.ImmutableList;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public final class Nameserver
extends Common {
    public static final String OBJECT_CLASS_NAME = "nameserver";
    public String handle;
    public DomainName ldhName;
    public DomainName unicodeName;
    public IpAddresses ipAddresses;

    @JsonCreator
    public Nameserver(@JsonProperty(value="links") List<Link> links, @JsonProperty(value="notices") List<Notice> notices, @JsonProperty(value="remarks") List<Notice> remarks, @JsonProperty(value="lang") String lang, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="status") List<Status> status, @JsonProperty(value="port43") DomainName port43, @JsonProperty(value="handle") String handle, @JsonProperty(value="ldhName") DomainName ldhName, @JsonProperty(value="unicodeName") DomainName unicodeName, @JsonProperty(value="ipAddresses") IpAddresses ipAddresses) {
        super(links, notices, remarks, lang, OBJECT_CLASS_NAME, events, status, port43);
        this.handle = handle;
        this.ldhName = ldhName;
        this.unicodeName = unicodeName;
        this.ipAddresses = ipAddresses;
    }

    public static class IpAddresses {
        private final List<String> v4;
        private final List<String> v6;

        @JsonCreator
        public IpAddresses(@JsonProperty(value="v4") List<String> v4, @JsonProperty(value="v6") List<String> v6) {
            this.v4 = new ImmutableList.Builder().addAll(v4).build();
            this.v6 = new ImmutableList.Builder().addAll(v6).build();
        }

        public IpAddresses(List<InetAddress> inetAddresses) {
            if (inetAddresses == null) {
                this.v4 = Collections.emptyList();
                this.v6 = Collections.emptyList();
                return;
            }
            ImmutableList.Builder v4Builder = new ImmutableList.Builder();
            ImmutableList.Builder v6Builder = new ImmutableList.Builder();
            for (InetAddress addr : inetAddresses) {
                if (addr instanceof Inet4Address) {
                    v4Builder.add((Object)addr.getHostAddress());
                }
                if (!(addr instanceof Inet6Address)) continue;
                v6Builder.add((Object)addr.getHostAddress());
            }
            this.v4 = v4Builder.build();
            this.v6 = v6Builder.build();
        }

        public List<String> getV4() {
            return this.v4;
        }

        public List<String> getV6() {
            return this.v6;
        }
    }
}

