/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.vcard.Contact;
import be.dnsbelgium.vcard.datatype.LanguageTag;
import be.dnsbelgium.vcard.datatype.StructuredValue;
import be.dnsbelgium.vcard.datatype.Tel;
import be.dnsbelgium.vcard.datatype.Text;
import be.dnsbelgium.vcard.datatype.URIValue;
import be.dnsbelgium.vcard.datatype.Value;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDeserializer
extends JsonDeserializer<Contact> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactDeserializer.class);
    private Map<String, DataTypeDeserializer<Value>> dataTypeDeserializerMap = new HashMap<String, DataTypeDeserializer<Value>>();

    public ContactDeserializer() {
        this.register("fn", new TextTypeDeserializer());
        this.register("n", new NTypeDeserializer());
        this.register("org", new ORGTypeDeserializer());
        this.register("adr", new ADRTypeDeserializer());
        this.register("email", new TextTypeDeserializer());
        this.register("lang", new LanguageTagTypeDeserializer());
        this.register("tel", new TELTypeDeserializer());
    }

    public Contact deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = oc.readTree(jp);
        ArrayList<Contact.Property> properties = new ArrayList<Contact.Property>();
        Iterator propertyNodes = node.getElements();
        while (propertyNodes.hasNext()) {
            String[] fullName;
            JsonNode propertyNode = (JsonNode)propertyNodes.next();
            if (!propertyNode.isArray() && propertyNode.size() < 4 || (fullName = propertyNode.get(0).getTextValue().split("\\.")).length > 2) continue;
            String group = fullName.length == 2 ? fullName[0] : null;
            String name = fullName.length == 2 ? fullName[1] : fullName[0];
            Contact.Parameters.Builder builder = new Contact.Parameters.Builder();
            Iterator parameters = propertyNode.get(1).getFields();
            while (parameters.hasNext()) {
                Map.Entry parameter = (Map.Entry)parameters.next();
                String key = (String)parameter.getKey();
                if (((JsonNode)parameter.getValue()).isArray()) {
                    Iterator paramValues = ((JsonNode)parameter.getValue()).getElements();
                    while (paramValues.hasNext()) {
                        String paramValue = ((JsonNode)paramValues.next()).getTextValue();
                        builder.add(key, paramValue);
                    }
                    continue;
                }
                builder.add(key, ((JsonNode)parameter.getValue()).getTextValue());
            }
            builder.add("VALUE", propertyNode.get(2).getTextValue());
            DataTypeDeserializer deserializer = this.getDeserializer(name);
            if (deserializer == null) continue;
            Object value = deserializer.deserialize(propertyNode);
            Contact.Property p = new Contact.Property(group, name, builder.build(), value);
            properties.add(p);
        }
        return new Contact(properties);
    }

    public final void register(String propertyName, DataTypeDeserializer deserializer) {
        this.dataTypeDeserializerMap.put(propertyName.toLowerCase(Locale.ENGLISH), deserializer);
    }

    public DataTypeDeserializer getDeserializer(String propertyName) {
        return this.dataTypeDeserializerMap.get(propertyName.toLowerCase(Locale.ENGLISH));
    }

    public static final class DeserializerUtils {
        private DeserializerUtils() {
        }

        public static List<String> toStringArray(JsonNode node) {
            if (node == null) {
                return null;
            }
            if (node.isArray()) {
                ArrayList<String> result = new ArrayList<String>();
                Iterator it = node.iterator();
                while (it.hasNext()) {
                    result.add(((JsonNode)it.next()).getTextValue());
                }
                return result;
            }
            return Arrays.asList(node.getTextValue());
        }
    }

    public static class LanguageTagTypeDeserializer
    extends DataTypeDeserializer<LanguageTag> {
        @Override
        public LanguageTag deserialize(JsonNode jsonNode) {
            return new LanguageTag(jsonNode.get(3).getTextValue());
        }
    }

    public static class TELTypeDeserializer
    extends DataTypeDeserializer<Tel> {
        @Override
        public Tel deserialize(JsonNode jsonNode) {
            String uriValue = jsonNode.get(3).getTextValue();
            try {
                URI uri = new URI(uriValue);
                return new Tel(uri.getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                LOGGER.debug(String.format("Invalid uri: %s", uriValue), (Throwable)e);
                return null;
            }
        }
    }

    public static class ADRTypeDeserializer
    extends DataTypeDeserializer<StructuredValue.ADRType> {
        @Override
        public StructuredValue.ADRType deserialize(JsonNode jsonNode) {
            return new StructuredValue.ADRType(DeserializerUtils.toStringArray(jsonNode.get(3)), DeserializerUtils.toStringArray(jsonNode.get(4)), DeserializerUtils.toStringArray(jsonNode.get(5)), DeserializerUtils.toStringArray(jsonNode.get(6)), DeserializerUtils.toStringArray(jsonNode.get(7)), DeserializerUtils.toStringArray(jsonNode.get(8)), DeserializerUtils.toStringArray(jsonNode.get(9)));
        }
    }

    public static class ORGTypeDeserializer
    extends DataTypeDeserializer<StructuredValue.ORGType> {
        @Override
        public StructuredValue.ORGType deserialize(JsonNode jsonNode) {
            String[] units = null;
            if (jsonNode.size() > 4) {
                units = new String[jsonNode.size() - 4];
                for (int i = 4; i < jsonNode.size(); ++i) {
                    units[i - 4] = jsonNode.get(i).getTextValue();
                }
            }
            return StructuredValue.ORGType.of(jsonNode.get(3).getTextValue(), units);
        }
    }

    public static class NTypeDeserializer
    extends DataTypeDeserializer<StructuredValue.NType> {
        @Override
        public StructuredValue.NType deserialize(JsonNode jsonNode) {
            return new StructuredValue.NType(DeserializerUtils.toStringArray(jsonNode.get(3)), DeserializerUtils.toStringArray(jsonNode.get(4)), DeserializerUtils.toStringArray(jsonNode.get(5)), DeserializerUtils.toStringArray(jsonNode.get(6)), DeserializerUtils.toStringArray(jsonNode.get(7)));
        }
    }

    public static class URITypeDeserializer
    extends DataTypeDeserializer<URIValue> {
        @Override
        public URIValue deserialize(JsonNode jsonNode) {
            String uri = jsonNode.get(3).getTextValue();
            try {
                return new URIValue(new URI(uri));
            }
            catch (URISyntaxException e) {
                LOGGER.debug(String.format("Syntax error in uri: %s", uri), (Throwable)e);
                return null;
            }
        }
    }

    public static class TextTypeDeserializer
    extends DataTypeDeserializer<Text> {
        @Override
        public Text deserialize(JsonNode jsonNode) {
            if (jsonNode.get(3) == null) {
                return new Text(null);
            }
            return new Text(jsonNode.get(3).getTextValue());
        }
    }

    public static abstract class DataTypeDeserializer<T extends Value> {
        public abstract T deserialize(JsonNode var1);
    }
}

