/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.jackson;

import be.dnsbelgium.rdap.core.Event;
import java.io.IOException;
import java.util.Locale;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDeserializer
extends JsonDeserializer<Event.Action> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionDeserializer.class);

    public Event.Action deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        final String value = jp.getText();
        LOGGER.debug("Creating Action of value '{}'", (Object)value);
        try {
            return Event.Action.Default.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Not a default action", (Throwable)iae);
            return new Event.Action(){

                @Override
                public String getValue() {
                    return value;
                }
            };
        }
    }
}

