/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Common;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Link;
import be.dnsbelgium.rdap.core.Notice;
import be.dnsbelgium.rdap.core.Status;
import com.google.common.collect.ImmutableList;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public final class Nameserver
extends Common {
    private final String handle;
    private final DomainName ldhName;
    private final DomainName unicodeName;
    private final IpAddresses ipAddresses;

    public IpAddresses getIpAddresses() {
        return this.ipAddresses;
    }

    public DomainName getUnicodeName() {
        return this.unicodeName;
    }

    public DomainName getLdhName() {
        return this.ldhName;
    }

    public String getHandle() {
        return this.handle;
    }

    @JsonCreator
    public Nameserver(@JsonProperty(value="rdapConformance") Set<String> rdapConformance, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="notices") List<Notice> notices, @JsonProperty(value="remarks") List<Notice> remarks, @JsonProperty(value="lang") String lang, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="status") List<Status> status, @JsonProperty(value="port43") DomainName port43, @JsonProperty(value="handle") String handle, @JsonProperty(value="ldhName") DomainName ldhName, @JsonProperty(value="unicodeName") DomainName unicodeName, @JsonProperty(value="ipAddresses") IpAddresses ipAddresses) {
        super(rdapConformance, links, notices, remarks, lang, events, status, port43);
        this.handle = handle;
        this.ldhName = ldhName;
        this.unicodeName = unicodeName;
        this.ipAddresses = ipAddresses;
    }

    public static class Builder {
        private List<InetAddress> inetAddresses;
        private DomainName ldhName;
        private DomainName unicodeName;

        public Builder addInetAddress(InetAddress addr) {
            if (addr == null) {
                return this;
            }
            if (this.inetAddresses == null) {
                this.inetAddresses = new ArrayList<InetAddress>();
            }
            this.inetAddresses.add(addr);
            return this;
        }

        public Builder setLDHName(DomainName ldhName) {
            this.ldhName = ldhName;
            return this;
        }

        public Builder setUnicodeName(DomainName unicodeName) {
            this.unicodeName = unicodeName;
            return this;
        }

        public Nameserver build() {
            return new Nameserver(null, null, null, null, null, null, null, null, null, this.ldhName, this.unicodeName, this.inetAddresses == null ? null : new IpAddresses(this.inetAddresses));
        }
    }

    public static class IpAddresses {
        private final List<String> v4;
        private final List<String> v6;

        @JsonCreator
        public IpAddresses(@JsonProperty(value="v4") List<String> v4, @JsonProperty(value="v6") List<String> v6) {
            this.v4 = new ImmutableList.Builder().addAll(v4).build();
            this.v6 = new ImmutableList.Builder().addAll(v6).build();
        }

        public IpAddresses(List<InetAddress> inetAddresses) {
            if (inetAddresses == null) {
                this.v4 = Collections.emptyList();
                this.v6 = Collections.emptyList();
                return;
            }
            ImmutableList.Builder v4Builder = new ImmutableList.Builder();
            ImmutableList.Builder v6Builder = new ImmutableList.Builder();
            for (InetAddress addr : inetAddresses) {
                if (addr instanceof Inet4Address) {
                    v4Builder.add((Object)addr.getHostAddress());
                }
                if (!(addr instanceof Inet6Address)) continue;
                v6Builder.add((Object)addr.getHostAddress());
            }
            this.v4 = v4Builder.build();
            this.v6 = v6Builder.build();
        }

        public List<String> getV4() {
            return this.v4;
        }

        public List<String> getV6() {
            return this.v6;
        }
    }
}

