/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.rdap.core.Event;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class SecureDNS {
    private final boolean zoneSigned;
    private final boolean delegationSigned;
    private final int maxSigLife;
    private final List<DSData> dsData;
    private final List<KeyData> keyData;

    @JsonCreator
    public SecureDNS(@JsonProperty(value="zoneSigned") boolean zoneSigned, @JsonProperty(value="delegationSigned") boolean delegationSigned, @JsonProperty(value="maxSigLife") int maxSigLife, @JsonProperty(value="dsData") List<DSData> dsData, @JsonProperty(value="keyData") List<KeyData> keyData) {
        this.zoneSigned = zoneSigned;
        this.delegationSigned = delegationSigned;
        this.maxSigLife = maxSigLife;
        this.dsData = dsData == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(dsData);
        this.keyData = keyData == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(keyData);
    }

    public boolean isZoneSigned() {
        return this.zoneSigned;
    }

    public boolean isDelegationSigned() {
        return this.delegationSigned;
    }

    public int getMaxSigLife() {
        return this.maxSigLife;
    }

    public List<DSData> getDsData() {
        return this.dsData;
    }

    public List<KeyData> getKeyData() {
        return this.keyData;
    }

    public static class KeyData {
        private final String flags;
        private final String protocol;
        private final String publicKey;
        private final int algorithm;
        private final List<Event> events;

        @JsonCreator
        public KeyData(@JsonProperty(value="flags") String flags, @JsonProperty(value="protocol") String protocol, @JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="algorithm") int algorithm, @JsonProperty(value="events") List<Event> events) {
            this.flags = flags;
            this.protocol = protocol;
            this.publicKey = publicKey;
            this.algorithm = algorithm;
            this.events = events == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(events);
        }

        public String getFlags() {
            return this.flags;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public List<Event> getEvents() {
            return this.events;
        }
    }

    public static class DSData {
        private final int keyTag;
        private final int algorithm;
        private final String digest;
        private final int digestType;
        private final List<Event> events;

        @JsonCreator
        public DSData(@JsonProperty(value="keyTag") int keyTag, @JsonProperty(value="algorithm") int algorithm, @JsonProperty(value="digest") String digest, @JsonProperty(value="digestType") int digestType, @JsonProperty(value="events") List<Event> events) {
            this.keyTag = keyTag;
            this.algorithm = algorithm;
            this.digest = digest;
            this.digestType = digestType;
            this.events = events == null ? new ImmutableList.Builder().build() : ImmutableList.copyOf(events);
        }

        public int getKeyTag() {
            return this.keyTag;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public String getDigest() {
            return this.digest;
        }

        public int getDigestType() {
            return this.digestType;
        }

        public List<Event> getEvents() {
            return this.events;
        }
    }
}

