/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public final class Link {
    private final URI value;
    private final String rel;
    private final URI href;
    private final Set<String> hreflang;
    private final List<String> title;
    private final String media;
    private final String type;

    @JsonCreator
    public Link(@JsonProperty(value="value") URI value, @JsonProperty(value="rel") String rel, @JsonProperty(value="href") URI href, @JsonProperty(value="hreflang") Set<String> hreflang, @JsonProperty(value="title") List<String> title, @JsonProperty(value="media") String media, @JsonProperty(value="type") String type) {
        if (value == null) {
            throw new IllegalArgumentException("value MUST be specified");
        }
        if (rel == null) {
            throw new IllegalArgumentException("rel MUST be specified");
        }
        if (href == null) {
            throw new IllegalArgumentException("href MUST be specified");
        }
        this.value = value;
        this.rel = rel;
        this.href = href;
        this.hreflang = hreflang == null ? null : new ImmutableSet.Builder().addAll(hreflang).build();
        this.title = title == null ? null : new ImmutableList.Builder().addAll(title).build();
        this.media = media;
        this.type = type;
    }

    public URI getValue() {
        return this.value;
    }

    public String getRel() {
        return this.rel;
    }

    public URI getHref() {
        return this.href;
    }

    public Set<String> getHreflang() {
        return this.hreflang;
    }

    public List<String> getTitle() {
        return this.title;
    }

    public String getMedia() {
        return this.media;
    }

    public String getType() {
        return this.type;
    }

    public static class Builder {
        private URI value;
        private String rel;
        private URI href;
        private Set<String> hreflang;
        private List<String> title;
        private String media;
        private String type;

        public Builder(String value, String rel, String href) throws URISyntaxException {
            this.value = new URI(value);
            this.rel = rel;
            this.href = new URI(href);
        }

        public Builder addHreflang(String hreflang) {
            if (this.hreflang == null) {
                this.hreflang = new HashSet<String>();
            }
            this.hreflang.add(hreflang);
            return this;
        }

        public Builder addTitle(String title) {
            if (this.title == null) {
                this.title = new ArrayList<String>();
            }
            this.title.add(title);
            return this;
        }

        public Link build() {
            return new Link(this.value, this.rel, this.href, this.hreflang, this.title, this.media, this.type);
        }
    }
}

