/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public class Error
extends Exception {
    private static final long serialVersionUID = 3000647771812593816L;
    private final int errorCode;
    private final String title;
    private final List<String> description;

    @JsonCreator
    public Error(@JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="title") String title, @JsonProperty(value="description") List<String> description) {
        this.errorCode = errorCode;
        this.title = title;
        this.description = description == null ? null : new ImmutableList.Builder().addAll(description).build();
    }

    @JsonCreator
    public Error(@JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description) {
        this(errorCode, title, description == null ? null : Arrays.asList(description));
    }

    @JsonCreator
    public Error(@JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="title") String title) {
        this(errorCode, title, (List<String>)null);
    }

    public Error(int errorCode, String title, List<String> description, Throwable cause) {
        this(errorCode, title, description);
        this.initCause(cause);
    }

    @JsonProperty
    public int getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public List<String> getDescription() {
        return this.description;
    }

    public static class NotAuthoritative
    extends Error {
        private static final long serialVersionUID = 7010767440479876394L;
        private final DomainName domainName;

        public NotAuthoritative(DomainName domainName) {
            super(301, String.format("Not authoritative for domain %s", domainName.toLDH().getStringValue()));
            this.domainName = domainName;
        }

        public DomainName getDomainName() {
            return this.domainName;
        }
    }

    public static class DomainNotFound
    extends Error {
        private static final long serialVersionUID = -1355753652647945804L;
        private final DomainName domainName;

        public DomainNotFound(DomainName domainName) {
            super(404, String.format("Domain %s not found", domainName.toLDH().getStringValue()));
            this.domainName = domainName;
        }

        public DomainName getDomainName() {
            return this.domainName;
        }
    }
}

