/*
 * Decompiled with CFR 0.152.
 */
package be.dnsbelgium.rdap.core;

import be.dnsbelgium.core.DomainName;
import be.dnsbelgium.rdap.core.Common;
import be.dnsbelgium.rdap.core.Entity;
import be.dnsbelgium.rdap.core.Event;
import be.dnsbelgium.rdap.core.Link;
import be.dnsbelgium.rdap.core.Nameserver;
import be.dnsbelgium.rdap.core.Notice;
import be.dnsbelgium.rdap.core.PublicId;
import be.dnsbelgium.rdap.core.Status;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Domain
extends Common {
    private final String handle;
    private final DomainName ldhName;
    private final DomainName unicodeName;
    private final List<Variant> variants;
    private final List<Nameserver> nameservers;
    private final List<DelegationKey> delegationKeys;
    private final List<Entity> entities;
    private final List<PublicId> publicIds;

    public List<PublicId> getPublicIds() {
        return this.publicIds;
    }

    public Domain(@JsonProperty(value="rdapConformance") Set<String> rdapConformance, @JsonProperty(value="links") List<Link> links, @JsonProperty(value="notices") List<Notice> notices, @JsonProperty(value="remarks") List<Notice> remarks, @JsonProperty(value="lang") String lang, @JsonProperty(value="events") List<Event> events, @JsonProperty(value="status") List<Status> status, @JsonProperty(value="port43") DomainName port43, @JsonProperty(value="handle") String handle, @JsonProperty(value="ldhName") DomainName ldhName, @JsonProperty(value="unicodeName") DomainName unicodeName, @JsonProperty(value="variants") List<Variant> variants, @JsonProperty(value="nameServers") List<Nameserver> nameservers, @JsonProperty(value="delegationKeys") List<DelegationKey> delegationKeys, @JsonProperty(value="entities") List<Entity> entities, @JsonProperty(value="publicIds") List<PublicId> publicIds) {
        super(rdapConformance, links, notices, remarks, lang, events, status, port43);
        this.handle = handle;
        this.ldhName = ldhName;
        this.unicodeName = unicodeName;
        this.variants = variants == null ? null : new ImmutableList.Builder().addAll(variants).build();
        this.nameservers = nameservers == null ? null : new ImmutableList.Builder().addAll(nameservers).build();
        this.delegationKeys = delegationKeys == null ? null : new ImmutableList.Builder().addAll(delegationKeys).build();
        this.entities = entities == null ? null : new ImmutableList.Builder().addAll(entities).build();
        this.publicIds = publicIds == null ? null : new ImmutableList.Builder().addAll(publicIds).build();
    }

    public String getHandle() {
        return this.handle;
    }

    public DomainName getLdhName() {
        return this.ldhName;
    }

    public DomainName getUnicodeName() {
        return this.unicodeName;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public List<Nameserver> getNameservers() {
        return this.nameservers;
    }

    public List<DelegationKey> getDelegationKeys() {
        return this.delegationKeys;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public static class Builder {
        private Set<String> rdapConformance = new HashSet<String>();
        private List<Link> links;
        private List<Notice> notices;
        private List<Notice> remarks;
        private String lang;
        private List<Event> events;
        private List<Status> status;
        private DomainName port43;
        private String handle;
        private DomainName ldhName;
        private DomainName unicodeName;
        private List<Variant> variants;
        private List<Nameserver> nameservers;
        private List<DelegationKey> delegationKeys;
        private List<Entity> entities;
        private List<PublicId> publicIds;

        public Builder() {
            this.rdapConformance.add("rdap_level_0");
        }

        public Builder addRDAPConformance(String conformance) {
            this.rdapConformance.add(conformance);
            return this;
        }

        public Builder setLDHName(String domainName) {
            this.ldhName = DomainName.of(domainName);
            return this;
        }

        public Builder setUnicodeName(String domainName) {
            this.unicodeName = DomainName.of(domainName);
            return this;
        }

        public Builder addStatus(Status status) {
            if (this.status == null) {
                this.status = new ArrayList<Status>();
            }
            this.status.add(status);
            return this;
        }

        public Builder addLink(Link link) {
            if (this.links == null) {
                this.links = new ArrayList<Link>();
            }
            this.links.add(link);
            return this;
        }

        public Builder setPort43(DomainName domainName) {
            this.port43 = domainName;
            return this;
        }

        public Builder addEntity(Entity entity) {
            if (this.entities == null) {
                this.entities = new ArrayList<Entity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder addEvent(Event e) {
            if (this.events == null) {
                this.events = new ArrayList<Event>();
            }
            this.events.add(e);
            return this;
        }

        public Builder addRemark(Notice n) {
            if (this.remarks == null) {
                this.remarks = new ArrayList<Notice>();
            }
            this.remarks.add(n);
            return this;
        }

        public Domain build() {
            return new Domain(this.rdapConformance, this.links, this.notices, this.remarks, this.lang, this.events, this.status, this.port43, this.handle, this.ldhName, this.unicodeName, this.variants, this.nameservers, this.delegationKeys, this.entities, this.publicIds);
        }

        public Builder addDelegationKey(DelegationKey delegationKey) {
            if (this.delegationKeys == null) {
                this.delegationKeys = new ArrayList<DelegationKey>();
            }
            this.delegationKeys.add(delegationKey);
            return this;
        }

        public Builder addNameserver(Nameserver ns) {
            if (this.nameservers == null) {
                this.nameservers = new ArrayList<Nameserver>();
            }
            this.nameservers.add(ns);
            return this;
        }
    }

    public static final class Variant {
        private final List<Relation> relations;
        private final String idnTable;
        private final List<Name> variantNames;

        @JsonCreator
        public Variant(@JsonProperty(value="relation") List<Relation> relations, @JsonProperty(value="idnTable") String idnTable, @JsonProperty(value="variantNames") List<Name> variantNames) {
            this.relations = new ImmutableList.Builder().addAll(relations).build();
            this.idnTable = idnTable;
            this.variantNames = new ImmutableList.Builder().addAll(variantNames).build();
        }

        public List<Relation> getRelations() {
            return this.relations;
        }

        public List<Name> getVariantNames() {
            return this.variantNames;
        }

        public static class Name {
            private final DomainName ldhName;
            private final DomainName unicodeName;

            @JsonCreator
            public Name(@JsonProperty(value="ldhName") DomainName ldhName, @JsonProperty(value="unicodeName") DomainName unicodeName) {
                this.ldhName = ldhName;
                this.unicodeName = unicodeName;
            }

            public DomainName getLdhName() {
                return this.ldhName;
            }

            public DomainName getUnicodeName() {
                return this.unicodeName;
            }
        }

        public static interface Relation {
            public String getValue();

            public static class BasicRelation
            implements Relation {
                private final String value;

                public BasicRelation(String value) {
                    this.value = value;
                }

                @Override
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Default implements Relation
            {
                REGISTERED("registered"),
                UNREGISTERED("unregistered"),
                RESTRICTED_REGISTRATION("restricted registration"),
                OPEN_REGISTRATION("open registration"),
                CONJOINED("conjoined");

                private final String value;

                private Default(String value) {
                    this.value = value;
                }

                @Override
                public String getValue() {
                    return this.value;
                }
            }

            public static final class Factory {
                private static final Logger LOGGER = LoggerFactory.getLogger(Factory.class);

                private Factory() {
                }

                public static Relation of(String relation) {
                    try {
                        return Default.valueOf(relation.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("Not a standard relation", (Throwable)iae);
                        return new BasicRelation(relation);
                    }
                }
            }
        }
    }

    public static final class DelegationKey {
        private final String digest;
        private final int algorithm;
        private final int digestType;
        private final int keyTag;

        public int getAlgorithm() {
            return this.algorithm;
        }

        public String getDigest() {
            return this.digest;
        }

        public int getDigestType() {
            return this.digestType;
        }

        public int getKeyTag() {
            return this.keyTag;
        }

        @JsonCreator
        public DelegationKey(@JsonProperty(value="algorithm") int algorithm, @JsonProperty(value="digest") String digest, @JsonProperty(value="digestType") int digestType, @JsonProperty(value="keyTag") int keyTag) {
            this.algorithm = algorithm;
            this.digest = digest;
            this.digestType = digestType;
            this.keyTag = keyTag;
        }
    }
}

